/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.util.serializable.codecs;

import es.pyronixstudio.util.colecciones.IndexedMap;
import es.pyronixstudio.util.serializable.PyronixBuff;
import es.pyronixstudio.util.serializable.codecs.ByteObjectCodec;
import es.pyronixstudio.util.serializable.codecs.CodecHelper;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;

public class Codecs {
    public static final ByteObjectCodec<String> STRING_CODEC = CodecHelper.create(PyronixBuff::writeString, PyronixBuff::readString);
    public static final ByteObjectCodec<Byte> BYTE_CODEC = CodecHelper.create(PyronixBuff::writeByte, PyronixBuff::readByte);
    public static final ByteObjectCodec<Short> SHORT_CODEC = CodecHelper.create(PyronixBuff::writeShort, PyronixBuff::readShort);
    public static final ByteObjectCodec<Integer> INT_CODEC = CodecHelper.create(PyronixBuff::writeInt, PyronixBuff::readInt);
    public static final ByteObjectCodec<Long> LONG_CODEC = CodecHelper.create(PyronixBuff::writeLong, PyronixBuff::readLong);
    public static final ByteObjectCodec<Double> DOUBLE_CODEC = CodecHelper.create(PyronixBuff::writeDouble, PyronixBuff::readDouble);
    public static final ByteObjectCodec<Float> FLOAT_CODEC = CodecHelper.create(PyronixBuff::writeFloat, PyronixBuff::readFloat);
    public static final ByteObjectCodec<Boolean> BOOLEAN_CODEC = CodecHelper.create(PyronixBuff::writeBoolean, PyronixBuff::readBoolean);
    public static final ByteObjectCodec<UUID> UUID_CODEC = CodecHelper.create(PyronixBuff::writeUUID, PyronixBuff::readUUID);

    public static final <T, C extends Collection<T>> ByteObjectCodec<C> ofCollection(ByteObjectCodec<T> codec, Supplier<C> collectionSupplier) {
        return CodecHelper.create((buff, list) -> buff.writeCollection(codec, list), buff -> buff.readCollection(codec, collectionSupplier));
    }

    public static final <T> ByteObjectCodec<List<T>> ofList(ByteObjectCodec<T> codec) {
        return CodecHelper.create((buff, list) -> buff.writeCollection(codec, list), buff -> buff.readList(codec));
    }

    public static final <K, V, C extends Map<K, V>> ByteObjectCodec<C> ofMap(ByteObjectCodec<K> keyCodec, ByteObjectCodec<V> valueCodec, Supplier<C> mapSupplier) {
        return CodecHelper.create((buff, map) -> buff.writeMap(keyCodec, valueCodec, map), buff -> buff.readMap(keyCodec, valueCodec, mapSupplier));
    }

    public static final <K, V> ByteObjectCodec<Map<K, V>> ofHashMap(ByteObjectCodec<K> keyCodec, ByteObjectCodec<V> valueCodec) {
        return CodecHelper.create((buff, map) -> buff.writeMap(keyCodec, valueCodec, map), buff -> buff.readHashMap(keyCodec, valueCodec));
    }

    public static final <K, V> ByteObjectCodec<IndexedMap<K, V>> ofIndexedMap(ByteObjectCodec<K> keyCodec, ByteObjectCodec<V> valueCodec) {
        return CodecHelper.create((buff, indexedMap) -> buff.writeIndexedMap(keyCodec, valueCodec, indexedMap), buff -> buff.readIndexedMap(keyCodec, valueCodec));
    }

    public static final <E extends Enum<E>> ByteObjectCodec<E> ofEnum(Class<E> enumClass) {
        return CodecHelper.create((buff, enumObject) -> buff.writeInt(enumObject.ordinal()), buff -> ((Enum[])enumClass.getEnumConstants())[buff.readInt()]);
    }

    public static final <T> ByteObjectCodec<Wrapper<T>> ofWrapper(ByteObjectCodec<T> objectCodec) {
        return Codecs.ofWrapper(objectCodec, false);
    }

    public static final <T> ByteObjectCodec<Wrapper<T>> ofWrapper(ByteObjectCodec<T> objectCodec, boolean unmodifiable) {
        return CodecHelper.create((buff, wrapper) -> {
            buff.writeBoolean(wrapper.isPresent());
            wrapper.ifPresent(obj -> buff.writeObject(objectCodec, obj));
        }, buff -> {
            boolean existe = buff.readBoolean();
            Object obj = null;
            if (existe) {
                obj = buff.readObject(objectCodec);
            }
            return Wrapper.create(obj, unmodifiable);
        });
    }
}

