/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.util.serializable;

import es.pyronixstudio.util.ficheros.PyronixFile;
import es.pyronixstudio.util.serializable.PyronixBuff;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public class Test {
    private static final int ITERATIONS = 100000;
    private static final int RUNS = 1000;
    private static final String TEST_STRING = "PyronixTestString";

    public static void main(String[] args) throws Exception {
        PyronixFile file = PyronixFile.of(Path.of("E:\\Windows\\Escritorio\\", new String[0]), "aaa");
        file.parsear();
        System.out.println(file.getElemento("colocacionbandera"));
    }

    private static void warmup() throws Exception {
        System.out.println("Warming up JVM...");
        for (int i = 0; i < 100; ++i) {
            Test.runBenchmark(BufferType.BYTEARRAYOUTPUT);
            Test.runBenchmark(BufferType.PYRONIX);
            Test.runBenchmark(BufferType.BYTEBUFFER);
        }
        System.out.println("Warmup done.\n");
    }

    private static double benchmarkRepeated(BufferType type) throws IOException {
        double total = 0.0;
        for (int i = 0; i < 1000; ++i) {
            total += Test.runBenchmark(type);
        }
        return total / 1000.0;
    }

    private static double runBenchmark(BufferType type) throws IOException {
        long start = System.nanoTime();
        switch (type.ordinal()) {
            case 0: {
                Test.runPyronixBuff();
                break;
            }
            case 1: {
                Test.runByteBuffer();
                break;
            }
            case 2: {
                Test.runByteArrayOutputStream();
            }
        }
        long end = System.nanoTime();
        return (double)(end - start) / 1000000.0;
    }

    private static void runPyronixBuff() {
        PyronixBuff buff = PyronixBuff.empty();
        for (int i = 0; i < 100000; ++i) {
            buff.writeInt(i);
            buff.writeLong((long)i * 2L);
            buff.writeFloat((float)i * 1.5f);
            buff.writeBoolean(i % 2 == 0);
            buff.writeString(TEST_STRING);
        }
        buff.toByteArray();
    }

    private static void runByteBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(4000000);
        for (int i = 0; i < 100000; ++i) {
            buffer.putInt(i);
            buffer.putLong((long)i * 2L);
            buffer.putFloat((float)i * 1.5f);
            buffer.put((byte)(i % 2));
            byte[] str = TEST_STRING.getBytes(StandardCharsets.UTF_8);
            buffer.putInt(str.length);
            buffer.put(str);
        }
        buffer.array();
    }

    private static void runByteArrayOutputStream() throws IOException {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(byteArray);
        for (int i = 0; i < 100000; ++i) {
            dataOut.writeInt(i);
            dataOut.writeLong((long)i * 2L);
            dataOut.writeFloat((float)i * 1.5f);
            dataOut.writeBoolean(i % 2 == 0);
            dataOut.writeUTF(TEST_STRING);
        }
        dataOut.flush();
    }

    private static enum BufferType {
        PYRONIX,
        BYTEBUFFER,
        BYTEARRAYOUTPUT;

    }
}

