/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.util.serializable;

import es.pyronixstudio.util.colecciones.IndexedMap;
import es.pyronixstudio.util.serializable.codecs.ICodec;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;

public class PyronixBuff {
    private static final int BYTES_TO_EXPAND = 100;
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private ByteBuffer buffer;

    public static PyronixBuff empty() {
        return PyronixBuff.allocate(100);
    }

    public static PyronixBuff allocate(int length) {
        return new PyronixBuff(length);
    }

    public static PyronixBuff wrap(byte[] payload) {
        return new PyronixBuff(ByteBuffer.wrap(payload));
    }

    private PyronixBuff(int length) {
        this.buffer = ByteBuffer.allocate(length);
    }

    private PyronixBuff(ByteBuffer buff) {
        this.buffer = buff;
    }

    public void writeByte(byte byteValue) {
        this.ensureCapacity(1);
        this.buffer.put(byteValue);
    }

    public byte readByte() {
        return this.buffer.get();
    }

    public void writeBytes(byte[] bytesData) {
        this.ensureCapacity(bytesData.length);
        this.buffer.put(bytesData);
    }

    public byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        this.buffer.get(bytes);
        return bytes;
    }

    public void writeShort(short shortValue) {
        this.ensureCapacity(2);
        this.buffer.putShort(shortValue);
    }

    public short readShort() {
        return this.buffer.getShort();
    }

    public void writeInt(int intValue) {
        this.ensureCapacity(4);
        this.buffer.putInt(intValue);
    }

    public int readInt() {
        return this.buffer.getInt();
    }

    public void writeLong(long longValue) {
        this.ensureCapacity(8);
        this.buffer.putLong(longValue);
    }

    public long readLong() {
        return this.buffer.getLong();
    }

    public void writeFloat(float floatValue) {
        this.ensureCapacity(4);
        this.buffer.putFloat(floatValue);
    }

    public float readFloat() {
        return this.buffer.getFloat();
    }

    public void writeDouble(double doubleValue) {
        this.ensureCapacity(8);
        this.buffer.putDouble(doubleValue);
    }

    public double readDouble() {
        return this.buffer.getDouble();
    }

    public <T> void writeObject(ICodec.IEncodable<T> codec, T object) {
        codec.encode(this, object);
    }

    public <T> T readObject(ICodec.IDecodable<T> codec) {
        return codec.decode(this);
    }

    public void writeString(String string) {
        this.writeString(string, DEFAULT_CHARSET);
    }

    public void writeString(String string, Charset charset) {
        byte[] bytes = string.getBytes(charset);
        this.writeInt(bytes.length);
        this.writeBytes(bytes);
    }

    public String readString(Charset charset) {
        int size = this.readInt();
        String resultString = new String(this.readBytes(size), charset);
        return resultString;
    }

    public String readString() {
        return this.readString(DEFAULT_CHARSET);
    }

    public void writeBoolean(boolean bool) {
        this.writeByte((byte)(bool ? 1 : 0));
    }

    public boolean readBoolean() {
        return this.readByte() == 1;
    }

    public void writeUUID(UUID uuid) {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    public UUID readUUID() {
        long mostSignificantBits = this.readLong();
        long leastSignificantBits = this.readLong();
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    public <K, V> void writeIndexedMap(ICodec.IEncodable<K> keyCodec, ICodec.IEncodable<V> valueCodec, IndexedMap<K, V> indexedMap) {
        Iterator<IndexedMap.IndexedEntry<K, V>> iterator = indexedMap.iterator();
        int count = indexedMap.size();
        this.writeInt(count);
        while (iterator.hasNext()) {
            IndexedMap.IndexedEntry<K, V> entry = iterator.next();
            K key = entry.getKey();
            V value = entry.getValue();
            this.writeObject(keyCodec, key);
            this.writeObject(valueCodec, value);
        }
    }

    public <K, V> IndexedMap<K, V> readIndexedMap(ICodec.IDecodable<K> keyDecodec, ICodec.IDecodable<V> valueDecodec) {
        IndexedMap<K, V> indexMap = IndexedMap.empty();
        for (int count = this.readInt(); count > 0; --count) {
            K key = this.readObject(keyDecodec);
            V value = this.readObject(valueDecodec);
            indexMap.put(key, value);
        }
        return indexMap;
    }

    public <T, C extends Collection<T>> void writeCollection(ICodec.IEncodable<T> codec, C collection) {
        int count = collection.size();
        this.writeInt(count);
        collection.forEach(element -> this.writeObject(codec, element));
    }

    public <T, C extends Collection<T>> C readCollection(ICodec.IDecodable<T> codec, Supplier<C> supplierCollection) {
        int count = this.readInt();
        Collection collection = (Collection)supplierCollection.get();
        for (int i = 0; i < count; ++i) {
            collection.add(this.readObject(codec));
        }
        return (C)collection;
    }

    public <T> List<T> readList(ICodec.IDecodable<T> codec) {
        return this.readCollection(codec, ArrayList::new);
    }

    public <K, V, R extends Map<K, V>> void writeMap(ICodec.IEncodable<K> keyCodec, ICodec.IEncodable<V> valueCodec, R map) {
        int count = map.size();
        this.writeInt(count);
        map.forEach((key, value) -> {
            this.writeObject(keyCodec, key);
            this.writeObject(valueCodec, value);
        });
    }

    public <K, V, R extends Map<K, V>> R readMap(ICodec.IDecodable<K> keyCodec, ICodec.IDecodable<V> valueCodec, Supplier<R> supplierMap) {
        Map map = (Map)supplierMap.get();
        for (int count = this.readInt(); count > 0; --count) {
            K key = this.readObject(keyCodec);
            V value = this.readObject(valueCodec);
            map.put(key, value);
        }
        return (R)map;
    }

    public <K, V> HashMap<K, V> readHashMap(ICodec.IDecodable<K> keyCodec, ICodec.IDecodable<V> valueCodec) {
        return this.readMap(keyCodec, valueCodec, HashMap::new);
    }

    private void ensureCapacity(int needed) {
        if (this.buffer.remaining() < needed) {
            int actualCapacity = this.buffer.capacity();
            int newCapacity = Math.max(actualCapacity * 2, actualCapacity + needed + 100);
            ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
    }

    public byte[] toByteArray() {
        int size = this.buffer.position();
        byte[] out = new byte[size];
        this.buffer.rewind();
        this.buffer.get(out);
        return out;
    }

    public void flip() {
        this.buffer.flip();
    }

    public int size() {
        return this.buffer.position();
    }

    public String toString() {
        return String.format("{PyronixBuff: Bytes: %s}", Arrays.toString(this.toByteArray()));
    }
}

