/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.util;

import java.util.function.Consumer;
import java.util.logging.Level;

public class Logger {
    private static LoggerResolver loggerResolver;

    public static void setLogger(LoggerResolver loggerResolver) {
        Logger.loggerResolver = loggerResolver;
    }

    public static void info(String mensaje, Object ... args) {
        Logger.enviar(Level.INFO, mensaje, args);
    }

    public static void warning(String mensaje, Object ... args) {
        Logger.enviar(Level.WARNING, mensaje, args);
    }

    public static void severe(String mensaje, Object ... args) {
        Logger.enviar(Level.SEVERE, mensaje, args);
    }

    private static Class<?> obtenerClaseInvocante() {
        StackTraceElement[] stack;
        for (StackTraceElement e : stack = Thread.currentThread().getStackTrace()) {
            String clase = e.getClassName();
            if (clase.equals(Logger.class.getName()) || clase.startsWith("java.lang.Thread")) continue;
            try {
                return Class.forName(clase);
            }
            catch (ClassNotFoundException ex) {
                return Logger.class;
            }
        }
        return Logger.class;
    }

    private static void enviar(Level nivel, String mensaje, Object ... args) {
        loggerResolver.log(nivel, Logger.format(Logger.obtenerClaseInvocante(), mensaje, args));
    }

    private static String format(Class<?> claseInvocante, String mensaje, Object ... args) {
        String padre = claseInvocante.getSuperclass().getSimpleName();
        String hijo = claseInvocante.getSimpleName();
        return String.format("[%s <= %s] -> %s", padre, hijo, String.format(mensaje, args));
    }

    public static class LoggerResolver {
        private final Consumer<String> info;
        private final Consumer<String> warning;
        private final Consumer<String> severe;
        private java.util.logging.Logger logger;

        public LoggerResolver(Consumer<String> info, Consumer<String> warning, Consumer<String> severe) {
            this.info = info;
            this.warning = warning;
            this.severe = severe;
        }

        public LoggerResolver(java.util.logging.Logger logger) {
            this(null, null, null);
            this.logger = logger;
        }

        public final void log(Level level, String mensaje) {
            if (this.logger != null) {
                this.logger.log(level, mensaje);
                return;
            }
            if (level.equals(Level.INFO)) {
                this.info.accept(mensaje);
                return;
            }
            if (level.equals(Level.WARNING)) {
                this.warning.accept(mensaje);
                return;
            }
            if (level.equals(Level.SEVERE)) {
                this.severe.accept(mensaje);
                return;
            }
        }
    }
}

