/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.util;

import java.util.concurrent.Callable;
import java.util.function.Consumer;

public interface IOpcionable<T> {
    public T get();

    public void set(T var1);

    default public T getOrDefault(T defaultValue) {
        return this.isPresent() ? this.get() : defaultValue;
    }

    default public boolean isEmpty() {
        return this.get() == null;
    }

    default public boolean isPresent() {
        return !this.isEmpty();
    }

    default public IOpcionable<T> ifPresent(Consumer<T> consumidorObjeto) {
        T valor = this.get();
        if (valor != null) {
            consumidorObjeto.accept(valor);
        }
        return this;
    }

    default public IOpcionable<T> ifPresentRunnable(Runnable runnable) {
        if (this.isEmpty()) {
            return this;
        }
        runnable.run();
        return this;
    }

    default public IOpcionable<T> ifEmpty(Runnable runnable) {
        if (this.isPresent()) {
            return this;
        }
        runnable.run();
        return this;
    }

    default public <R> R finnaly(Callable<R> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

