/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.util.ficheros;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class FicheroBase {
    protected File archivo;
    protected Path ruta;

    public static FicheroBase of(Path ruta) {
        return new FicheroBase(ruta);
    }

    protected FicheroBase(Path ruta) {
        this.ruta = ruta;
        this.archivo = ruta.toFile();
    }

    public Path getRuta() {
        return this.ruta;
    }

    public boolean existe() {
        return this.archivo.exists();
    }

    public void crearSiNoExiste() {
        try {
            File parent = this.archivo.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            if (!this.archivo.exists()) {
                this.archivo.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean borrarCarpeta(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                this.borrarCarpeta(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    public void borrar() {
        if (this.archivo.exists()) {
            if (this.archivo.isDirectory()) {
                this.borrarCarpeta(this.archivo);
            } else {
                this.archivo.delete();
            }
        }
    }

    public void escribirLineas(List<String> lineas) {
        this.crearSiNoExiste();
        try (BufferedWriter out = Files.newBufferedWriter(this.archivo.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            for (String linea : lineas) {
                out.write(linea);
                out.newLine();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public void vaciar() {
        this.escribirLineas(Collections.emptyList());
    }

    public List<String> getAllLines() {
        ArrayList<String> lineas = new ArrayList<String>();
        this.ejecutarFuncionACadaLinea(lineas::add);
        return lineas;
    }

    public void ejecutarFuncionACadaLinea(Consumer<String> consumerLinea) {
        try (BufferedReader reader = Files.newBufferedReader(this.archivo.toPath(), StandardCharsets.UTF_8);){
            String lineaActual;
            while ((lineaActual = reader.readLine()) != null) {
                consumerLinea.accept(lineaActual);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

