/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.util.serializable.codecs;

import es.pyronixstudio.util.functional.function.Function3;
import es.pyronixstudio.util.functional.function.Function4;
import es.pyronixstudio.util.functional.function.Function5;
import es.pyronixstudio.util.functional.function.Function6;
import es.pyronixstudio.util.serializable.PyronixBuff;
import es.pyronixstudio.util.serializable.codecs.ByteObjectCodec;
import es.pyronixstudio.util.serializable.codecs.ICodec;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public interface CodecHelper {
    public static <T> ByteObjectCodec<T> create(final BiConsumer<PyronixBuff, T> encodec, final Function<PyronixBuff, T> decodec) {
        return new ByteObjectCodec<T>(){

            @Override
            public void encode(PyronixBuff buff, T object) {
                if (encodec == null) {
                    return;
                }
                encodec.accept(buff, object);
            }

            @Override
            public T decode(PyronixBuff buff) {
                if (decodec == null) {
                    return null;
                }
                return decodec.apply(buff);
            }
        };
    }

    public static <O> ByteObjectCodec<O> create(Supplier<O> constructor) {
        return CodecHelper.create(null, buff -> constructor.get());
    }

    public static <O, P1> ByteObjectCodec<O> composite(final ByteObjectCodec<P1> codec1, final Function<O, P1> p1, final Function<P1, O> constructor) {
        ByteObjectCodec byteObject = new ByteObjectCodec<O>(){

            @Override
            public void encode(PyronixBuff buff, O object) {
                buff.writeObject(codec1, p1.apply(object));
            }

            @Override
            public O decode(PyronixBuff buff) {
                Object p12 = codec1.decode(buff);
                return constructor.apply(p12);
            }
        };
        return byteObject;
    }

    public static <O, P1, P2> ByteObjectCodec<O> composite(final ByteObjectCodec<P1> codec1, final Function<O, P1> p1, final ByteObjectCodec<P2> codec2, final Function<O, P2> p2, final BiFunction<P1, P2, O> constructor) {
        ByteObjectCodec byteObject = new ByteObjectCodec<O>(){

            @Override
            public void encode(PyronixBuff buff, O object) {
                buff.writeObject(codec1, p1.apply(object));
                buff.writeObject(codec2, p2.apply(object));
            }

            @Override
            public O decode(PyronixBuff buff) {
                Object p12 = codec1.decode(buff);
                Object p22 = codec2.decode(buff);
                return constructor.apply(p12, p22);
            }
        };
        return byteObject;
    }

    public static <O, P1, P2, P3> ByteObjectCodec<O> composite(final ByteObjectCodec<P1> codec1, final Function<O, P1> p1, final ByteObjectCodec<P2> codec2, final Function<O, P2> p2, final ByteObjectCodec<P3> codec3, final Function<O, P3> p3, final Function3<P1, P2, P3, O> constructor) {
        ByteObjectCodec byteObject = new ByteObjectCodec<O>(){

            @Override
            public void encode(PyronixBuff buff, O object) {
                buff.writeObject(codec1, p1.apply(object));
                buff.writeObject(codec2, p2.apply(object));
                buff.writeObject(codec3, p3.apply(object));
            }

            @Override
            public O decode(PyronixBuff buff) {
                Object p12 = codec1.decode(buff);
                Object p22 = codec2.decode(buff);
                Object p32 = codec3.decode(buff);
                return constructor.apply(p12, p22, p32);
            }
        };
        return byteObject;
    }

    public static <O, P1, P2, P3, P4> ByteObjectCodec<O> composite(final ByteObjectCodec<P1> codec1, final Function<O, P1> p1, final ByteObjectCodec<P2> codec2, final Function<O, P2> p2, final ByteObjectCodec<P3> codec3, final Function<O, P3> p3, final ByteObjectCodec<P4> codec4, final Function<O, P4> p4, final Function4<P1, P2, P3, P4, O> constructor) {
        ByteObjectCodec byteObject = new ByteObjectCodec<O>(){

            @Override
            public void encode(PyronixBuff buff, O object) {
                buff.writeObject(codec1, p1.apply(object));
                buff.writeObject(codec2, p2.apply(object));
                buff.writeObject(codec3, p3.apply(object));
                buff.writeObject(codec4, p4.apply(object));
            }

            @Override
            public O decode(PyronixBuff buff) {
                Object p12 = codec1.decode(buff);
                Object p22 = codec2.decode(buff);
                Object p32 = codec3.decode(buff);
                Object p42 = codec4.decode(buff);
                return constructor.apply(p12, p22, p32, p42);
            }
        };
        return byteObject;
    }

    public static <O, P1, P2, P3, P4, P5> ByteObjectCodec<O> composite(final ByteObjectCodec<P1> codec1, final Function<O, P1> p1, final ByteObjectCodec<P2> codec2, final Function<O, P2> p2, final ByteObjectCodec<P3> codec3, final Function<O, P3> p3, final ByteObjectCodec<P4> codec4, final Function<O, P4> p4, final ByteObjectCodec<P5> codec5, final Function<O, P5> p5, final Function5<P1, P2, P3, P4, P5, O> constructor) {
        ByteObjectCodec byteObject = new ByteObjectCodec<O>(){

            @Override
            public void encode(PyronixBuff buff, O object) {
                buff.writeObject(codec1, p1.apply(object));
                buff.writeObject(codec2, p2.apply(object));
                buff.writeObject(codec3, p3.apply(object));
                buff.writeObject(codec4, p4.apply(object));
                buff.writeObject(codec5, p5.apply(object));
            }

            @Override
            public O decode(PyronixBuff buff) {
                Object p12 = codec1.decode(buff);
                Object p22 = codec2.decode(buff);
                Object p32 = codec3.decode(buff);
                Object p42 = codec4.decode(buff);
                Object p52 = codec5.decode(buff);
                return constructor.apply(p12, p22, p32, p42, p52);
            }
        };
        return byteObject;
    }

    public static <O, P1, P2, P3, P4, P5, P6> ByteObjectCodec<O> composite(final ByteObjectCodec<P1> codec1, final Function<O, P1> p1, final ByteObjectCodec<P2> codec2, final Function<O, P2> p2, final ByteObjectCodec<P3> codec3, final Function<O, P3> p3, final ByteObjectCodec<P4> codec4, final Function<O, P4> p4, final ByteObjectCodec<P5> codec5, final Function<O, P5> p5, final ByteObjectCodec<P6> codec6, final Function<O, P6> p6, final Function6<P1, P2, P3, P4, P5, P6, O> constructor) {
        ByteObjectCodec byteObject = new ByteObjectCodec<O>(){

            @Override
            public void encode(PyronixBuff buff, O object) {
                buff.writeObject(codec1, p1.apply(object));
                buff.writeObject(codec2, p2.apply(object));
                buff.writeObject(codec3, p3.apply(object));
                buff.writeObject(codec4, p4.apply(object));
                buff.writeObject(codec5, p5.apply(object));
                buff.writeObject(codec6, p6.apply(object));
            }

            @Override
            public O decode(PyronixBuff buff) {
                Object p12 = codec1.decode(buff);
                Object p22 = codec2.decode(buff);
                Object p32 = codec3.decode(buff);
                Object p42 = codec4.decode(buff);
                Object p52 = codec5.decode(buff);
                Object p62 = codec6.decode(buff);
                return constructor.apply(p12, p22, p32, p42, p52, p62);
            }
        };
        return byteObject;
    }

    public static <O, P1> ICodec.IDecodable<O> onlyDecode(final ICodec.IDecodable<P1> codec1, final Function<P1, O> constructor) {
        return new ICodec.IDecodable<O>(){

            @Override
            public O decode(PyronixBuff buff) {
                Object p1 = codec1.decode(buff);
                return constructor.apply(p1);
            }
        };
    }

    public static <O, P1, P2> ICodec.IDecodable<O> onlyDecode(final ICodec.IDecodable<P1> codec1, final ICodec.IDecodable<P2> codec2, final BiFunction<P1, P2, O> constructor) {
        return new ICodec.IDecodable<O>(){

            @Override
            public O decode(PyronixBuff buff) {
                Object p1 = codec1.decode(buff);
                Object p2 = codec2.decode(buff);
                return constructor.apply(p1, p2);
            }
        };
    }

    public static <O, P1, P2, P3> ICodec.IDecodable<O> onlyDecode(final ICodec.IDecodable<P1> codec1, final ICodec.IDecodable<P2> codec2, final ICodec.IDecodable<P3> codec3, final Function3<P1, P2, P3, O> constructor) {
        return new ICodec.IDecodable<O>(){

            @Override
            public O decode(PyronixBuff buff) {
                Object p1 = codec1.decode(buff);
                Object p2 = codec2.decode(buff);
                Object p3 = codec3.decode(buff);
                return constructor.apply(p1, p2, p3);
            }
        };
    }

    public static <O, P1, P2, P3, P4> ICodec.IDecodable<O> onlyDecode(final ICodec.IDecodable<P1> codec1, final ICodec.IDecodable<P2> codec2, final ICodec.IDecodable<P3> codec3, final ICodec.IDecodable<P4> codec4, final Function4<P1, P2, P3, P4, O> constructor) {
        return new ICodec.IDecodable<O>(){

            @Override
            public O decode(PyronixBuff buff) {
                Object p1 = codec1.decode(buff);
                Object p2 = codec2.decode(buff);
                Object p3 = codec3.decode(buff);
                Object p4 = codec4.decode(buff);
                return constructor.apply(p1, p2, p3, p4);
            }
        };
    }

    public static <O, P1, P2, P3, P4, P5> ICodec.IDecodable<O> onlyDecode(final ICodec.IDecodable<P1> codec1, final ICodec.IDecodable<P2> codec2, final ICodec.IDecodable<P3> codec3, final ICodec.IDecodable<P4> codec4, final ICodec.IDecodable<P5> codec5, final Function5<P1, P2, P3, P4, P5, O> constructor) {
        return new ICodec.IDecodable<O>(){

            @Override
            public O decode(PyronixBuff buff) {
                Object p1 = codec1.decode(buff);
                Object p2 = codec2.decode(buff);
                Object p3 = codec3.decode(buff);
                Object p4 = codec4.decode(buff);
                Object p5 = codec5.decode(buff);
                return constructor.apply(p1, p2, p3, p4, p5);
            }
        };
    }

    public static <O, P1, P2, P3, P4, P5, P6> ICodec.IDecodable<O> onlyDecode(final ICodec.IDecodable<P1> codec1, final ICodec.IDecodable<P2> codec2, final ICodec.IDecodable<P3> codec3, final ICodec.IDecodable<P4> codec4, final ICodec.IDecodable<P5> codec5, final ICodec.IDecodable<P6> codec6, final Function6<P1, P2, P3, P4, P5, P6, O> constructor) {
        return new ICodec.IDecodable<O>(){

            @Override
            public O decode(PyronixBuff buff) {
                Object p1 = codec1.decode(buff);
                Object p2 = codec2.decode(buff);
                Object p3 = codec3.decode(buff);
                Object p4 = codec4.decode(buff);
                Object p5 = codec5.decode(buff);
                Object p6 = codec6.decode(buff);
                return constructor.apply(p1, p2, p3, p4, p5, p6);
            }
        };
    }
}

