/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.util.ficheros;

import es.pyronixstudio.util.EnumUtil;
import es.pyronixstudio.util.ficheros.Elemento;
import es.pyronixstudio.util.ficheros.PyronixFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;

public class Valor {
    private String valor;

    public static Valor of(Object valor) {
        return new Valor(valor.toString());
    }

    private Valor(String valor) {
        this.valor = valor;
    }

    public <T> T asCustom(Class<T> clase) {
        return this.getInstancia(clase, null);
    }

    public <T> T asCustom(Function<String, T> constructor) {
        return constructor.apply(this.asString());
    }

    public boolean asBoolean(boolean porDefecto) {
        return this.getInstancia(Boolean.class, porDefecto);
    }

    public byte asByte(byte porDefecto) {
        return this.getInstancia(Byte.class, porDefecto);
    }

    public short asShort(short porDefecto) {
        return this.getInstancia(Short.class, porDefecto);
    }

    public int asInt(int porDefecto) {
        return this.getInstancia(Integer.class, porDefecto);
    }

    public Long asLong(long porDefecto) {
        return this.getInstancia(Long.class, porDefecto);
    }

    public float asFloat(float porDefecto) {
        return this.getInstancia(Float.class, Float.valueOf(porDefecto)).floatValue();
    }

    public double asDouble(double porDefecto) {
        return this.getInstancia(Double.class, porDefecto);
    }

    public String asString(String porDefecto) {
        return this.getInstancia(String.class, porDefecto);
    }

    public String[] asStringArray(String spliterator) {
        return this.valor.replace("[", "").replace("]", "").split(spliterator);
    }

    public String[] asStringArray() {
        return this.asStringArray(",");
    }

    public Valor[] asArray(String spliterator) {
        String[] arrayString = this.asStringArray(spliterator);
        Valor[] array = new Valor[arrayString.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Valor.of(arrayString[i]);
        }
        return array;
    }

    public Valor[] asArray() {
        return this.asArray(",");
    }

    public List<String> asStringList() {
        return List.of(this.asStringArray());
    }

    public <T> List<T> asList(Function<Valor, T> transformador) {
        ArrayList<T> lista = new ArrayList<T>();
        for (String id : this.asStringArray()) {
            lista.add(transformador.apply(Valor.of(id)));
        }
        return lista;
    }

    public List<String> asStringList(String spliterator) {
        return List.of(this.asStringArray(spliterator));
    }

    public Map<String, Valor> asMap(String spliterator) {
        String[] array;
        HashMap<String, Valor> mapa = new HashMap<String, Valor>();
        for (String claveValor : array = this.asStringArray(spliterator)) {
            Matcher matcher = PyronixFile.PATRON_CLAVE_VALOR.matcher(claveValor);
            if (!matcher.matches()) continue;
            String clave = matcher.group(1).trim();
            String valor = matcher.group(2).trim();
            mapa.put(clave, Valor.of(valor));
        }
        return mapa;
    }

    public Map<String, Valor> asMap() {
        return this.asMap(",");
    }

    public Elemento asElemento() {
        return Elemento.of("", this.asMap());
    }

    public Elemento asUnmodifiableElemento() {
        return Elemento.ofUnmodifiable("", this.asMap());
    }

    public <T extends Enum<T>> T asEnum(Class<T> enumCLase) {
        return (T)((Enum)this.getInstancia(enumCLase, null));
    }

    public boolean asBoolean() {
        return this.asBoolean(false);
    }

    public byte asByte() {
        return this.asByte((byte)0);
    }

    public short asShort() {
        return this.asShort((short)0);
    }

    public int asInt() {
        return this.asInt(0);
    }

    public Long asLong() {
        return this.asLong(0L);
    }

    public float asFloat() {
        return this.asFloat(0.0f);
    }

    public double asDouble() {
        return this.asDouble(0.0);
    }

    public String asString() {
        return this.asString("");
    }

    private <T> T getInstancia(Class<T> clase, T porDefecto) {
        ArrayList<String> casteo = null;
        try {
            if (clase.isEnum()) {
                casteo = (ArrayList<String>)EnumUtil.valueOfSecure(clase, this.valor);
            } else if (clase == String.class) {
                casteo = this.valor;
            } else if (clase == Boolean.class) {
                casteo = Boolean.valueOf(this.valor);
            } else if (clase == Byte.class) {
                casteo = Byte.valueOf(this.valor);
            } else if (clase == Short.class) {
                casteo = Short.valueOf(this.valor);
            } else if (clase == Integer.class) {
                casteo = Integer.valueOf(this.valor);
            } else if (clase == Long.class) {
                casteo = Long.valueOf(this.valor);
            } else if (clase == Float.class) {
                casteo = Float.valueOf(this.valor);
            } else if (clase == Double.class) {
                casteo = Double.valueOf(this.valor);
            } else if (clase == List.class) {
                casteo = new ArrayList<String>(List.of(this.valor.split(",")));
            }
        }
        catch (NumberFormatException e) {
            casteo = null;
        }
        return casteo == null ? porDefecto : clase.cast(casteo);
    }

    public String toString() {
        return String.format("[Valor:%s]", this.valor);
    }
}

