/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.util.ficheros;

import es.pyronixstudio.util.ficheros.ElementoInmodificable;
import es.pyronixstudio.util.ficheros.Valor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Elemento {
    public final String id;
    private final Map<String, Valor> valores = new LinkedHashMap<String, Valor>();

    public static Elemento empty(String id) {
        return Elemento.of(id, new LinkedHashMap<String, Valor>());
    }

    public static Elemento of(String id, Map<String, Valor> valores) {
        return valores == null ? Elemento.empty(id) : new Elemento(id, valores);
    }

    public static Elemento emptyUnmodifiable(String id) {
        return Elemento.ofUnmodifiable(id, new LinkedHashMap<String, Valor>());
    }

    public static Elemento ofUnmodifiable(String id, Map<String, Valor> valores) {
        return valores == null ? Elemento.emptyUnmodifiable(id) : new ElementoInmodificable(id, valores);
    }

    protected Elemento(String id) {
        this.id = id.toLowerCase();
    }

    protected Elemento(String id, Map<String, Valor> valores) {
        this(id);
        if (valores != null) {
            this.valores.putAll(valores);
        }
    }

    public void add(String key, Object nuevoValor) {
        this.valores.put(key, Valor.of(nuevoValor.toString()));
    }

    public Valor get(String key) {
        return this.valores.get(key);
    }

    public Valor getOrDefault(String key, Object valorDefecto) {
        Valor valor = this.get(key);
        return valor == null ? Valor.of(valorDefecto) : valor;
    }

    public List<Valor> getAll(String key) {
        return new ArrayList<Valor>(this.valores.values());
    }

    public int size() {
        return this.valores.size();
    }

    public List<String> serialize() {
        ArrayList<String> lineas = new ArrayList<String>();
        lineas.add(String.format("#%s {", this.id));
        this.valores.entrySet().forEach(pareja -> lineas.add(String.format("%s: %s", pareja.getKey(), ((Valor)pareja.getValue()).asString())));
        lineas.add("}");
        return lineas;
    }

    public String toString() {
        return String.format("[Valores:%s]", this.valores);
    }
}

