/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.util.colecciones;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class IndexedMap<K, V>
implements Iterable<IndexedEntry<K, V>>,
Serializable {
    private static final long serialVersionUID = 743649797121760052L;
    private final List<K> claves = new ArrayList<K>();
    private final Map<K, V> mapa = new HashMap();
    private transient int mutaciones = 0;

    public static <K, V> IndexedMap<K, V> empty() {
        return new IndexedMap<K, V>();
    }

    public static <K, V> IndexedMap<K, V> of(Map<K, V> map) {
        IndexedMap<K, V> mapaCreado = IndexedMap.empty();
        map.forEach(mapaCreado::put);
        return mapaCreado;
    }

    public static <K, V, C, B> IndexedMap<K, V> of(Map<C, B> mapa, Function<C, K> transformarClave, Function<B, V> transformarValor) {
        IndexedMap<K, V> mapaCreado = IndexedMap.empty();
        mapaCreado.putAll(mapa, transformarClave, transformarValor);
        return mapaCreado;
    }

    public static <K, V> IndexedMap<K, V> of(Collection<IndexedEntry<K, V>> coleccion) {
        IndexedMap<K, V> mapaCreado = IndexedMap.empty();
        mapaCreado.putAll(coleccion);
        return mapaCreado;
    }

    private IndexedMap() {
    }

    public void put(K key, V value) {
        if (key == null || value == null) {
            return;
        }
        if (!this.mapa.containsKey(key)) {
            this.claves.add(key);
            this.sumarMutacion();
        }
        this.mapa.put(key, value);
    }

    public void put(IndexedEntry<K, V> indexedEntry) {
        this.put(indexedEntry.key, indexedEntry.value);
    }

    public void putAll(Collection<IndexedEntry<K, V>> coleccion) {
        if (coleccion == null || coleccion.isEmpty()) {
            return;
        }
        coleccion.forEach(this::put);
    }

    public void putAll(IndexedMap<K, V> otroMapa) {
        if (otroMapa == null || otroMapa.isEmpty()) {
            return;
        }
        otroMapa.forEach(this::put);
    }

    public <C, B> void putAll(Map<C, B> mapa, Function<C, K> transformarClave, Function<B, V> transformarValor) {
        mapa.forEach((? super K claveObject, ? super V valorObject) -> {
            Object clave = transformarClave.apply(claveObject);
            Object valor = transformarValor.apply(valorObject);
            this.put(clave, valor);
        });
    }

    public V get(K key) {
        return this.mapa.get(key);
    }

    public V getOrDefault(K key, V defaultValue) {
        V value = this.get(key);
        return value != null ? value : defaultValue;
    }

    public IndexedEntry<K, V> get(int index) {
        K clave = this.claves.get(index);
        V valor = this.mapa.get(clave);
        return this.newEntry(clave, valor);
    }

    public IndexedEntry<K, V> getFirst() {
        return this.get(0);
    }

    public IndexedEntry<K, V> getLast() {
        return this.get(this.claves.size() - 1);
    }

    public V remove(K key) {
        V borrado = this.mapa.remove(key);
        this.claves.remove(key);
        if (borrado != null) {
            this.sumarMutacion();
        }
        return borrado;
    }

    public V remove(int index) {
        K key = this.claves.get(index);
        return this.remove(key);
    }

    public boolean containsKey(K key) {
        return this.mapa.containsKey(key);
    }

    public <T extends Collection<IndexedEntry<K, V>>> T asCollection(T coleccion) {
        this.forEach(coleccion::add);
        return coleccion;
    }

    public int size() {
        return this.claves.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.mapa.clear();
        this.claves.clear();
        this.mutaciones = 0;
    }

    public void removeIf(Predicate<? super IndexedEntry<K, V>> predicado) {
        Iterator<IndexedEntry<K, V>> it = this.iterator();
        while (it.hasNext()) {
            if (!predicado.test(it.next())) continue;
            it.remove();
        }
    }

    private IndexedEntry<K, V> newEntry(K key, V value) {
        return IndexedEntry.of(this, key, value);
    }

    private void sumarMutacion() {
        ++this.mutaciones;
    }

    @Override
    public Iterator<IndexedEntry<K, V>> iterator() {
        return new Iterator<IndexedEntry<K, V>>(){
            private int cursor = 0;
            private int indiceUltimaClave = -1;
            private int mutacionesEsperadas;
            {
                this.mutacionesEsperadas = IndexedMap.this.mutaciones;
            }

            @Override
            public boolean hasNext() {
                this.checkSeguridadConcurrencia();
                return this.cursor < IndexedMap.this.claves.size();
            }

            @Override
            public IndexedEntry<K, V> next() {
                this.checkSeguridadConcurrencia();
                this.indiceUltimaClave = this.cursor;
                Object clave = IndexedMap.this.claves.get(this.cursor++);
                Object valor = IndexedMap.this.mapa.get(clave);
                return IndexedIterableEntry.of(clave, valor);
            }

            @Override
            public void remove() {
                if (this.indiceUltimaClave == -1) {
                    throw new IllegalStateException();
                }
                this.checkSeguridadConcurrencia();
                IndexedMap.this.remove(this.indiceUltimaClave);
                this.cursor = this.indiceUltimaClave;
                this.indiceUltimaClave = -1;
                this.mutacionesEsperadas = IndexedMap.this.mutaciones;
            }

            private void checkSeguridadConcurrencia() {
                if (this.mutacionesEsperadas != IndexedMap.this.mutaciones) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    public Stream<IndexedEntry<K, V>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public String toString() {
        return String.format("[IndexedMap %s]", this.mapa.toString());
    }

    public static class IndexedEntry<K, V>
    implements Serializable {
        private static final long serialVersionUID = 9079695216498175838L;
        private final K key;
        private V value;
        private final IndexedMap<K, V> indexedMap;

        private static <K, V> IndexedEntry<K, V> of(IndexedMap<K, V> indexedMap, K key, V value) {
            return new IndexedEntry<K, V>(indexedMap, key, value);
        }

        protected IndexedEntry(IndexedMap<K, V> indexedMap, K key, V value) {
            this.indexedMap = indexedMap;
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V value) {
            this.value = value;
            this.indexedMap.put(this.key, value);
            return value;
        }

        public void remove() {
            this.indexedMap.remove(this.key);
        }

        public String toString() {
            return String.format("[IndexedEntry key:%s value:%s]", this.key, this.value);
        }
    }

    public static class IndexedIterableEntry<K, V>
    extends IndexedEntry<K, V> {
        private static final long serialVersionUID = 4887834265201524329L;

        private static <K, V> IndexedIterableEntry<K, V> of(K key, V value) {
            return new IndexedIterableEntry<K, V>(key, value);
        }

        protected IndexedIterableEntry(K key, V value) {
            super(null, key, value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove via IndexedEntry during iteration; use Iterator.remove() instead.");
        }
    }
}

