/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.util;

public class EnumUtil {
    public static <T> T valueOfSecure(Class<T> clase, String valor) {
        if (!clase.isEnum()) {
            return null;
        }
        Enum valorEnum = EnumUtil.valueOfEnum(clase.asSubclass(Enum.class), valor);
        if (valorEnum == null) {
            return null;
        }
        return clase.cast(valorEnum);
    }

    private static <E extends Enum<E>> E valueOfEnum(Class<E> claseEnum, String valor) {
        try {
            return Enum.valueOf(claseEnum, valor.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }
}

