/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.util;

import es.pyronixstudio.util.colecciones.IndexedMap;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class RandomUtil {
    private static Random random = new Random();

    public static <T> T getRandomFromArray(T[] array) {
        int max = array.length - 1;
        int min = 0;
        return array[RandomUtil.getRandom(min, max)];
    }

    public static <T> T getRandomFromCollection(Collection<T> coleccion) {
        return RandomUtil.getRandomFromList(new ArrayList<T>(coleccion));
    }

    public static <T> T getRandomFromList(List<T> lista) {
        Wrapper<Integer> optionalRandom = RandomUtil.getRandomIndex(lista.size());
        if (optionalRandom.isPresent()) {
            return lista.get(optionalRandom.get());
        }
        return null;
    }

    public static <K, V> IndexedMap.IndexedEntry<K, V> getRandomFromIndexedMap(IndexedMap<K, V> indexedMap) {
        Wrapper<Integer> optionalRandom = RandomUtil.getRandomIndex(indexedMap.size());
        if (optionalRandom.isPresent()) {
            return indexedMap.get(optionalRandom.get());
        }
        return null;
    }

    private static Wrapper<Integer> getRandomIndex(int size) {
        if (size <= 0) {
            return Wrapper.empty();
        }
        return Wrapper.of(RandomUtil.getRandom(0, size - 1));
    }

    public static int getRandom(int min, int max) {
        return random.nextInt(min, max + 1);
    }

    public static float getRandom(float min, float max) {
        return random.nextFloat(min, max + 1.0f);
    }

    public static double getRandom(double min, double max) {
        return random.nextDouble(min, max + 1.0);
    }
}

