/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.util.serializable;

import es.pyronixstudio.util.colecciones.IndexedMap;
import es.pyronixstudio.util.serializable.codecs.ICodec;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;

public class PyronixBuff {
    private static final int BYTES_TO_EXPAND = 100;
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private byte[] buffer;
    private int writePosition = 0;
    private int readPosition = 0;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public static PyronixBuff empty() {
        return PyronixBuff.allocate(100);
    }

    public static PyronixBuff allocate(int length) {
        return new PyronixBuff(length);
    }

    public static PyronixBuff wrap(byte[] payload) {
        return new PyronixBuff(payload);
    }

    private PyronixBuff(byte[] buffer) {
        this.buffer = buffer;
    }

    private PyronixBuff(int length) {
        this(new byte[length]);
    }

    private void updateWritePosition(int writted) {
        this.writePosition += writted;
    }

    private void updateReadPosition(int readed) {
        this.readPosition += readed;
    }

    public void writeByte(byte byteValue) {
        int needed = 1;
        this.ensureCapacity(needed);
        this.buffer[this.writePosition] = byteValue;
        this.updateWritePosition(needed);
    }

    public byte readByte() {
        byte readedByte = this.buffer[this.readPosition];
        this.updateReadPosition(1);
        return readedByte;
    }

    public void writeBytes(byte[] bytesData) {
        int needed = bytesData.length;
        this.ensureCapacity(needed);
        System.arraycopy(bytesData, 0, this.buffer, this.writePosition, needed);
        this.updateWritePosition(needed);
    }

    public void readBytes(byte[] bufferToWrite) {
        int length = bufferToWrite.length;
        System.arraycopy(this.buffer, this.readPosition, bufferToWrite, 0, length);
        this.updateReadPosition(length);
    }

    public byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        this.readBytes(bytes);
        return bytes;
    }

    public void writeShort(short shortValue) {
        int needed = 2;
        this.ensureCapacity(needed);
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.buffer[this.writePosition] = (byte)(shortValue >>> 8);
            this.buffer[this.writePosition + 1] = (byte)shortValue;
        } else {
            this.buffer[this.writePosition] = (byte)shortValue;
            this.buffer[this.writePosition + 1] = (byte)(shortValue >>> 8);
        }
        this.updateWritePosition(needed);
    }

    public short readShort() {
        short resultado = this.byteOrder == ByteOrder.BIG_ENDIAN ? (short)((this.buffer[this.readPosition] & 0xFF) << 8 | this.buffer[this.readPosition + 1] & 0xFF) : (short)(this.buffer[this.readPosition] & 0xFF | (this.buffer[this.readPosition + 1] & 0xFF) << 8);
        this.updateReadPosition(2);
        return resultado;
    }

    public void writeInt(int intValue) {
        int needed = 4;
        this.ensureCapacity(needed);
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.buffer[this.writePosition] = (byte)(intValue >>> 24);
            this.buffer[this.writePosition + 1] = (byte)(intValue >>> 16);
            this.buffer[this.writePosition + 2] = (byte)(intValue >>> 8);
            this.buffer[this.writePosition + 3] = (byte)intValue;
        } else {
            this.buffer[this.writePosition] = (byte)intValue;
            this.buffer[this.writePosition + 1] = (byte)(intValue >>> 8);
            this.buffer[this.writePosition + 2] = (byte)(intValue >>> 16);
            this.buffer[this.writePosition + 3] = (byte)(intValue >>> 24);
        }
        this.updateWritePosition(needed);
    }

    public int readInt() {
        int resultado = this.byteOrder == ByteOrder.BIG_ENDIAN ? (this.buffer[this.readPosition] & 0xFF) << 24 | (this.buffer[this.readPosition + 1] & 0xFF) << 16 | (this.buffer[this.readPosition + 2] & 0xFF) << 8 | this.buffer[this.readPosition + 3] & 0xFF : this.buffer[this.readPosition] & 0xFF | (this.buffer[this.readPosition + 1] & 0xFF) << 8 | (this.buffer[this.readPosition + 2] & 0xFF) << 16 | (this.buffer[this.readPosition + 3] & 0xFF) << 24;
        this.updateReadPosition(4);
        return resultado;
    }

    public void writeLong(long longValue) {
        int needed = 8;
        this.ensureCapacity(needed);
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.buffer[this.writePosition] = (byte)(longValue >>> 56);
            this.buffer[this.writePosition + 1] = (byte)(longValue >>> 48);
            this.buffer[this.writePosition + 2] = (byte)(longValue >>> 40);
            this.buffer[this.writePosition + 3] = (byte)(longValue >>> 32);
            this.buffer[this.writePosition + 4] = (byte)(longValue >>> 24);
            this.buffer[this.writePosition + 5] = (byte)(longValue >>> 16);
            this.buffer[this.writePosition + 6] = (byte)(longValue >>> 8);
            this.buffer[this.writePosition + 7] = (byte)longValue;
        } else {
            this.buffer[this.writePosition] = (byte)longValue;
            this.buffer[this.writePosition + 1] = (byte)(longValue >>> 8);
            this.buffer[this.writePosition + 2] = (byte)(longValue >>> 16);
            this.buffer[this.writePosition + 3] = (byte)(longValue >>> 24);
            this.buffer[this.writePosition + 4] = (byte)(longValue >>> 32);
            this.buffer[this.writePosition + 5] = (byte)(longValue >>> 40);
            this.buffer[this.writePosition + 6] = (byte)(longValue >>> 48);
            this.buffer[this.writePosition + 7] = (byte)(longValue >>> 56);
        }
        this.updateWritePosition(needed);
    }

    public long readLong() {
        long resultado = this.byteOrder == ByteOrder.BIG_ENDIAN ? (long)(this.buffer[this.readPosition] & 0xFF) << 56 | (long)(this.buffer[this.readPosition + 1] & 0xFF) << 48 | (long)(this.buffer[this.readPosition + 2] & 0xFF) << 40 | (long)(this.buffer[this.readPosition + 3] & 0xFF) << 32 | (long)(this.buffer[this.readPosition + 4] & 0xFF) << 24 | (long)(this.buffer[this.readPosition + 5] & 0xFF) << 16 | (long)(this.buffer[this.readPosition + 6] & 0xFF) << 8 | (long)(this.buffer[this.readPosition + 7] & 0xFF) : (long)(this.buffer[this.readPosition] & 0xFF) | (long)(this.buffer[this.readPosition + 1] & 0xFF) << 8 | (long)(this.buffer[this.readPosition + 2] & 0xFF) << 16 | (long)(this.buffer[this.readPosition + 3] & 0xFF) << 24 | (long)(this.buffer[this.readPosition + 4] & 0xFF) << 32 | (long)(this.buffer[this.readPosition + 5] & 0xFF) << 40 | (long)(this.buffer[this.readPosition + 6] & 0xFF) << 48 | (long)(this.buffer[this.readPosition + 7] & 0xFF) << 56;
        this.updateReadPosition(8);
        return resultado;
    }

    public void writeFloat(float floatValue) {
        int intBits = Float.floatToIntBits(floatValue);
        this.writeInt(intBits);
    }

    public float readFloat() {
        int intBits = this.readInt();
        return Float.intBitsToFloat(intBits);
    }

    public void writeDouble(double doubleValue) {
        long longBits = Double.doubleToLongBits(doubleValue);
        this.writeLong(longBits);
    }

    public double readDouble() {
        long longBits = this.readLong();
        return Double.longBitsToDouble(longBits);
    }

    public <T> void writeObject(ICodec.IEncodable<T> codec, T object) {
        codec.encode(this, object);
    }

    public <T> T readObject(ICodec.IDecodable<T> codec) {
        return codec.decode(this);
    }

    public void writeString(String string) {
        this.writeString(string, DEFAULT_CHARSET);
    }

    public void writeString(String string, Charset charset) {
        byte[] bytes = string.getBytes(charset);
        this.writeInt(bytes.length);
        this.writeBytes(bytes);
    }

    public String readString(Charset charset) {
        int size = this.readInt();
        return new String(this.readBytes(size), charset);
    }

    public String readString() {
        return this.readString(DEFAULT_CHARSET);
    }

    public void writeChar(char character) {
        this.writeInt(character);
    }

    public char readChar() {
        return (char)this.readInt();
    }

    public void writeBoolean(boolean bool) {
        this.writeByte((byte)(bool ? 1 : 0));
    }

    public boolean readBoolean() {
        return this.readByte() == 1;
    }

    public void writeUUID(UUID uuid) {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    public UUID readUUID() {
        long mostSignificantBits = this.readLong();
        long leastSignificantBits = this.readLong();
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    public <K, V> void writeIndexedMap(ICodec.IEncodable<K> keyCodec, ICodec.IEncodable<V> valueCodec, IndexedMap<K, V> indexedMap) {
        Iterator<IndexedMap.IndexedEntry<K, V>> iterator = indexedMap.iterator();
        int count = indexedMap.size();
        this.writeInt(count);
        while (iterator.hasNext()) {
            IndexedMap.IndexedEntry<K, V> entry = iterator.next();
            K key = entry.getKey();
            V value = entry.getValue();
            this.writeObject(keyCodec, key);
            this.writeObject(valueCodec, value);
        }
    }

    public <K, V> IndexedMap<K, V> readIndexedMap(ICodec.IDecodable<K> keyDecodec, ICodec.IDecodable<V> valueDecodec) {
        IndexedMap<K, V> indexMap = IndexedMap.empty();
        for (int count = this.readInt(); count > 0; --count) {
            K key = this.readObject(keyDecodec);
            V value = this.readObject(valueDecodec);
            indexMap.put(key, value);
        }
        return indexMap;
    }

    public <T, C extends Collection<T>> void writeCollection(ICodec.IEncodable<T> codec, C collection) {
        int count = collection.size();
        this.writeInt(count);
        collection.forEach(element -> this.writeObject(codec, element));
    }

    public <T, C extends Collection<T>> C readCollection(ICodec.IDecodable<T> codec, Supplier<C> supplierCollection) {
        int count = this.readInt();
        Collection collection = (Collection)supplierCollection.get();
        for (int i = 0; i < count; ++i) {
            collection.add(this.readObject(codec));
        }
        return (C)collection;
    }

    public <T> List<T> readList(ICodec.IDecodable<T> codec) {
        return this.readCollection(codec, ArrayList::new);
    }

    public <K, V, R extends Map<K, V>> void writeMap(ICodec.IEncodable<K> keyCodec, ICodec.IEncodable<V> valueCodec, R map) {
        int count = map.size();
        this.writeInt(count);
        map.forEach((key, value) -> {
            this.writeObject(keyCodec, key);
            this.writeObject(valueCodec, value);
        });
    }

    public <K, V, R extends Map<K, V>> R readMap(ICodec.IDecodable<K> keyCodec, ICodec.IDecodable<V> valueCodec, Supplier<R> supplierMap) {
        Map map = (Map)supplierMap.get();
        for (int count = this.readInt(); count > 0; --count) {
            K key = this.readObject(keyCodec);
            V value = this.readObject(valueCodec);
            map.put(key, value);
        }
        return (R)map;
    }

    public <K, V> HashMap<K, V> readHashMap(ICodec.IDecodable<K> keyCodec, ICodec.IDecodable<V> valueCodec) {
        return this.readMap(keyCodec, valueCodec, HashMap::new);
    }

    private void ensureCapacity(int needed) {
        if (this.remaining() < needed) {
            int actualCapacity = this.buffer.length;
            int newCapacity = Math.max(actualCapacity * 2, actualCapacity + needed + 100);
            byte[] newBuffer = new byte[newCapacity];
            System.arraycopy(this.buffer, 0, newBuffer, 0, actualCapacity);
            this.buffer = newBuffer;
        }
    }

    private int remaining() {
        return this.buffer.length - this.writePosition;
    }

    public byte[] toByteArray() {
        int maxPosition = Math.max(this.writePosition, this.readPosition);
        return Arrays.copyOf(this.buffer, maxPosition);
    }

    public int size() {
        return this.writePosition;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public String toString() {
        return String.format("{PyronixBuff: Bytes: %s}", Arrays.toString(this.toByteArray()));
    }
}

