/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.util.ficheros;

import es.pyronixstudio.util.Logger;
import es.pyronixstudio.util.ficheros.Elemento;
import es.pyronixstudio.util.ficheros.ElementoComentario;
import es.pyronixstudio.util.ficheros.FicheroBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PyronixFile
extends FicheroBase {
    private static final Pattern PATRON_ELEMENTO = Pattern.compile("#([\\w-]+)\\s*\\{");
    public static final Pattern PATRON_CLAVE_VALOR = Pattern.compile("([^:]+):\\s*(.*)");
    private static final String COMENTARIO = "//";
    private static final String EXTENSION = ".pyx";
    private boolean error = false;
    private Map<String, Elemento> elementos = new LinkedHashMap<String, Elemento>();

    public static void copiarFichero(String nombreFicheroSinExtension, String ... carpetas) {
        PyronixFile.copiarFichero(nombreFicheroSinExtension, (Path)null, carpetas);
    }

    public static void copiarFichero(String nombreFicheroSinExtension, PyronixFile ficheroDestino, String ... carpetas) {
        PyronixFile.copiarFichero(nombreFicheroSinExtension, ficheroDestino.ruta, carpetas);
    }

    public static void copiarFichero(String nombreFicheroSinExtension, Path ficheroDestino, String ... carpetas) {
        String rutaInternaJar = String.format("/%s/%s%s", String.join((CharSequence)"/", carpetas), nombreFicheroSinExtension, EXTENSION);
        PyronixFile fichero = PyronixFile.of(ficheroDestino = ficheroDestino != null ? ficheroDestino : Path.of(".", new String[0]));
        if (fichero.existe()) {
            return;
        }
        try (InputStream stream = PyronixFile.class.getResourceAsStream(rutaInternaJar);){
            if (stream == null) {
                Logger.warning("No se encontro el recurso: %s", rutaInternaJar);
                return;
            }
            ArrayList<String> contenido = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                String linea;
                while ((linea = reader.readLine()) != null) {
                    contenido.add(linea);
                }
            }
            fichero.escribirLineas(contenido);
        }
        catch (Exception e) {
            Logger.severe("Error al copiar el archivo: %s", rutaInternaJar);
            Logger.severe(e.toString(), new Object[0]);
        }
    }

    public static Path rutaParsed(Path ruta) {
        File fichero = ruta.toFile();
        String nombreFichero = fichero.getName();
        if (!nombreFichero.endsWith(EXTENSION) && !fichero.isDirectory()) {
            return ruta.resolveSibling(String.format("%s%s", nombreFichero, EXTENSION));
        }
        return ruta;
    }

    private PyronixFile(Path ruta) {
        super(ruta);
        this.ruta = ruta;
        this.archivo = PyronixFile.rutaParsed(ruta).toFile();
    }

    public static PyronixFile of(Path ruta) {
        return new PyronixFile(ruta);
    }

    public static PyronixFile of(String ruta) {
        return PyronixFile.of(Path.of(ruta, new String[0]));
    }

    public static PyronixFile of(Path rutaPadre, String ... hijos) {
        Path rutaResultante = rutaPadre;
        for (String hijo : hijos) {
            rutaResultante = rutaResultante.resolve(hijo);
        }
        return PyronixFile.of(rutaResultante);
    }

    public void parsear() {
        this.elementos.clear();
        this.error = false;
        try (BufferedReader reader = Files.newBufferedReader(this.archivo.toPath(), StandardCharsets.UTF_8);){
            String lineaActual;
            int comentarios = 0;
            while ((lineaActual = reader.readLine()) != null) {
                String idElemento;
                boolean exito;
                if (this.esLineaInvalida(lineaActual = lineaActual.trim())) {
                    if (!lineaActual.startsWith(COMENTARIO)) continue;
                    this.elementos.put(String.format("comment-%s", comentarios++), ElementoComentario.of(lineaActual));
                    continue;
                }
                Matcher matcher = PATRON_ELEMENTO.matcher(lineaActual);
                if (!matcher.matches() || (exito = this.parsearElemento(reader, idElemento = matcher.group(1)))) continue;
                this.error = true;
                Logger.severe("Error en el elemento: %s", idElemento);
                break;
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private boolean esLineaInvalida(String linea) {
        return linea.startsWith(COMENTARIO) || linea.isBlank();
    }

    private boolean parsearElemento(BufferedReader reader, String idElemento) throws IOException {
        String lineaElemento;
        boolean bienCerrado = false;
        Elemento elemento = Elemento.empty(idElemento);
        while ((lineaElemento = reader.readLine()) != null) {
            if (this.esLineaInvalida(lineaElemento = lineaElemento.trim())) continue;
            if (lineaElemento.equals("}")) {
                bienCerrado = true;
                break;
            }
            if (PATRON_ELEMENTO.matcher(lineaElemento).matches()) break;
            Matcher claveValorMatcher = PATRON_CLAVE_VALOR.matcher(lineaElemento);
            if (!claveValorMatcher.matches()) continue;
            String clave = claveValorMatcher.group(1).trim();
            String valor = claveValorMatcher.group(2).trim();
            if (valor.startsWith("[")) {
                StringBuilder contenidoArray = new StringBuilder();
                if (valor.endsWith("]")) {
                    contenidoArray.append(valor.substring(1, valor.length() - 1).trim().replace(" ", ""));
                } else {
                    contenidoArray.append(valor.substring(1).trim());
                    while ((lineaElemento = reader.readLine()) != null && !(lineaElemento = lineaElemento.trim()).equals("]")) {
                        contenidoArray.append(lineaElemento);
                    }
                }
                elemento.add(clave, contenidoArray.toString());
                continue;
            }
            elemento.add(clave, valor);
        }
        this.elementos.put(idElemento.toLowerCase(), elemento);
        return bienCerrado;
    }

    public Elemento getElemento(String key) {
        return this.elementos.get(key.toLowerCase());
    }

    public void ejecutarFuncionACadaElemento(Consumer<Elemento> consumer) {
        for (String id : this.getIds()) {
            consumer.accept(this.getElemento(id));
        }
    }

    public void serializar() {
        if (this.error) {
            return;
        }
        ArrayList<String> lineas = new ArrayList<String>();
        this.elementos.entrySet().forEach(pareja -> lineas.addAll(((Elemento)pareja.getValue()).serialize()));
        this.escribirLineas(lineas);
    }

    public void agregarElemento(Elemento elemento) {
        this.elementos.put(elemento.id, elemento);
    }

    public void agregarTodo(List<Elemento> elementosAAgregar) {
        elementosAAgregar.forEach(this::agregarElemento);
    }

    public void borrarElemento(Elemento elemento) {
        this.elementos.remove(elemento.id);
    }

    public Set<Elemento> getElementoQueContenga(String aContener) {
        HashSet<Elemento> devolver = new HashSet<Elemento>();
        for (Map.Entry<String, Elemento> elemento : this.elementos.entrySet()) {
            String id = elemento.getKey();
            if (!id.contains(aContener)) continue;
            devolver.add(elemento.getValue());
        }
        return devolver;
    }

    public List<String> getIds() {
        return new ArrayList<String>(this.elementos.keySet());
    }

    public boolean hasError() {
        return this.error;
    }

    public String toString() {
        return this.elementos.toString();
    }
}

