/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.util;

import es.pyronixstudio.util.colecciones.IndexedMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;

public class RandomUtil {
    private static Random random = new Random();

    public static <T> T getElementoRandom(T[] array) {
        int max = array.length - 1;
        int min = 0;
        return array[RandomUtil.getRandom(min, max)];
    }

    public static final <T> T getRandomFromCollection(Collection<T> coleccion) {
        return RandomUtil.getRandomFromCollection(new ArrayList<T>(coleccion));
    }

    public static final <T> T getRandomFromList(List<T> lista) {
        Optional<Integer> optionalRandom = RandomUtil.getRandomIndex(lista.size());
        if (optionalRandom.isPresent()) {
            return lista.get(optionalRandom.get());
        }
        return null;
    }

    public static final <K, V> IndexedMap.IndexedEntry<K, V> getRandomFromIndexedMap(IndexedMap<K, V> indexedMap) {
        Optional<Integer> optionalRandom = RandomUtil.getRandomIndex(indexedMap.size());
        if (optionalRandom.isPresent()) {
            return indexedMap.get(optionalRandom.get());
        }
        return null;
    }

    private static final Optional<Integer> getRandomIndex(int size) {
        if (size <= 0) {
            return Optional.empty();
        }
        return Optional.of(RandomUtil.getRandom(0, size - 1));
    }

    public static int getRandom(int min, int max) {
        return random.nextInt(min, max + 1);
    }

    public static float getRandom(float min, float max) {
        return random.nextFloat(min, max + 1.0f);
    }

    public static double getRandom(double min, double max) {
        return random.nextDouble(min, max + 1.0);
    }
}

