/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.util.serializable;

import es.pyronixstudio.util.serializable.PyronixBuff;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class TestShift {
    public static void main(String[] args) {
        int numero = -2346;
        int pos = numero * -1;
        PyronixBuff buffa = PyronixBuff.empty();
        buffa.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        buffa.writeInt(numero);
        buffa.writeInt(pos);
        PyronixBuff a = PyronixBuff.empty();
        a.writeInt(numero);
        a.writeInt(pos);
        System.out.println(Arrays.toString(a.toByteArray()));
        System.out.println(Arrays.toString(buffa.toByteArray()));
        PyronixBuff buffo = PyronixBuff.wrap(buffa.toByteArray());
        buffo.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        System.out.println(buffo.readInt() + "  " + buffo.readInt());
        String test = "HOLa amigos somos aordos !\u00bf?=";
        PyronixBuff buff = PyronixBuff.empty();
        buff.writeString(test);
        System.out.println(Arrays.toString(buff.toByteArray()));
        System.out.println(buff.readString());
        byte[] manual = TestShift.writeString(test);
        System.out.println(Arrays.toString(manual));
        System.out.println(TestShift.readString(manual));
        System.out.println(Arrays.toString(TestShift.writeInt(10)));
        System.out.println(Arrays.toString(TestShift.writeInt(10)));
    }

    public static byte[] writeString(String texto) {
        return texto.getBytes(StandardCharsets.UTF_8);
    }

    public static String readString(byte[] data) {
        String resultString = new String(data, StandardCharsets.UTF_8);
        return resultString;
    }

    private static byte[] writeShort(short shortNumber) {
        byte[] resultado = new byte[]{(byte)(shortNumber >>> 8), (byte)shortNumber};
        return resultado;
    }

    private static short readShort(byte[] array) {
        short numero = (short)((array[0] & 0xFF) << 8 | array[1] & 0xFF);
        return numero;
    }

    private static byte[] writeInt(int entero) {
        byte[] resultado = new byte[]{(byte)(entero >>> 24), (byte)(entero >>> 16), (byte)(entero >>> 8), (byte)entero};
        return resultado;
    }

    private static int readInt(byte[] array) {
        int numero = (array[0] & 0xFF) << 24 | (array[1] & 0xFF) << 16 | (array[2] & 0xFF) << 8 | array[3] & 0xFF;
        return numero;
    }
}

