/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.interfacesbukkit.paquetes.cliente;

import es.pyronixstudio.interfacesbukkit.paquetes.cliente.IRequest;
import es.pyronixstudio.util.Logger;
import es.pyronixstudio.util.serializable.PyronixBuff;
import es.pyronixstudio.util.serializable.codecs.ICodec;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class RequestDispatcher {
    private static RequestDispatcher INSTANCE = new RequestDispatcher();
    private Map<Integer, ICodec.IDecodable<? extends IRequest>> solicitudes = new ConcurrentHashMap<Integer, ICodec.IDecodable<? extends IRequest>>();

    private RequestDispatcher() {
    }

    public static void registerRequest(int id, ICodec.IDecodable<? extends IRequest> request) {
        if (!RequestDispatcher.INSTANCE.solicitudes.containsKey(id)) {
            RequestDispatcher.INSTANCE.solicitudes.put(id, request);
        }
    }

    public static void handleRequest(PyronixBuff data, Player player) {
        int id = data.readInt();
        try {
            if (!RequestDispatcher.INSTANCE.solicitudes.containsKey(id)) {
                Logger.info((String)"LLego una solicitud que no existe: %s", (Object[])new Object[]{Arrays.toString(data.toByteArray())});
                return;
            }
            ICodec.IDecodable<? extends IRequest> request = RequestDispatcher.INSTANCE.solicitudes.get(id);
            ((IRequest)request.decode(data)).handleRequest(player);
        }
        catch (Exception e) {
            Logger.severe((String)"Ocurrio un error al procesar la solicitud con id %s", (Object[])new Object[]{id});
            e.printStackTrace();
        }
    }
}

