/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.interfacesbukkit.paquetes;

import es.pyronixstudio.interfacesbukkit.InterfacesPlugin;
import es.pyronixstudio.interfacesbukkit.paquetes.IOverlay;
import es.pyronixstudio.interfacesbukkit.paquetes.IPlayable;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.Logger;
import es.pyronixstudio.util.serializable.ISendeable;
import es.pyronixstudio.util.serializable.PyronixBuff;
import es.pyronixstudio.util.serializable.codecs.ICodec;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ClientNetwork {
    public static <T extends ISendeable> byte[] encodePayloadAndSimpleData(ICodec.IEncodable<? extends T> codec, T object) {
        PyronixBuff buff = PyronixBuff.empty();
        buff.writeByte(object.getID());
        if (object instanceof IOverlay) {
            IOverlay overlay = (IOverlay)object;
            buff.writeBoolean(overlay.show());
        }
        if (codec != null) {
            buff.writeObject(codec, (Object)((ISendeable)CastUtil.cast(object)));
        }
        return buff.toByteArray();
    }

    public static void enviarPaquete(Player player, byte[] datos) {
        if (datos != null && player != null && player.isOnline()) {
            player.sendPluginMessage(InterfacesPlugin.plugin, "pyronix:interfaces", datos);
        }
    }

    public static <T extends ISendeable> void enviarPaquete(Player player, ICodec.IEncodable<? extends T> codec, T object) {
        ClientNetwork.enviarPaquete(player, ClientNetwork.encodePayloadAndSimpleData(codec, object));
    }

    public static <T extends ISendeable> void enviarPaquete(IPlayable iPlayable, ICodec.IEncodable<? extends T> codec, T object) {
        ClientNetwork.enviarPaquete(iPlayable.getMinecraftPlayer(), codec, object);
    }

    public static void enviarPaquete(UUID uuid, byte[] datos) {
        ClientNetwork.enviarPaquete(Bukkit.getPlayer((UUID)uuid), datos);
    }

    public static <T extends ISendeable> void enviarPaquete(UUID uuid, ICodec.IEncodable<? extends T> codec, T object) {
        ClientNetwork.enviarPaquete(Bukkit.getPlayer((UUID)uuid), codec, object);
    }

    public static <P, T extends ISendeable> void enviarPaquete(Collection<P> infoPlayers, ICodec.IEncodable<? extends T> codec, T object) {
        byte[] packetByte = ClientNetwork.encodePayloadAndSimpleData(codec, object);
        block5: for (P infoPlayer : infoPlayers) {
            P p;
            Objects.requireNonNull(infoPlayer);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Player.class, UUID.class, IPlayable.class}, p, n)) {
                case 0: {
                    Player player = (Player)p;
                    ClientNetwork.enviarPaquete(player, packetByte);
                    continue block5;
                }
                case 1: {
                    UUID uuid = (UUID)p;
                    ClientNetwork.enviarPaquete(uuid, packetByte);
                    continue block5;
                }
                case 2: {
                    IPlayable iPlayable = (IPlayable)p;
                    ClientNetwork.enviarPaquete(iPlayable.getMinecraftPlayer(), packetByte);
                    continue block5;
                }
            }
            Logger.info((String)"Se paso una lista imcompatible usa solo UUID,Player", (Object[])new Object[0]);
        }
    }
}

