/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.interfacesbukkit;

import es.pyronixstudio.interfacesbukkit.paquetes.ClientNetwork;
import es.pyronixstudio.interfacesbukkit.paquetes.cliente.RequestDispatcher;
import es.pyronixstudio.interfacesbukkit.paquetes.server.HandShakePacket;
import es.pyronixstudio.util.serializable.PyronixBuff;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class InterfacesPlugin
implements Listener {
    public static InterfacesPlugin INSTANCE;
    public static final String CHANNEL = "pyronix:interfaces";
    public static Plugin plugin;
    private static final int GLOBAL_PROTOCOL_VERSION = 2;
    private static HandShakePacket paqueteHandShake;

    public InterfacesPlugin(Plugin plugin, int protocolVersion, boolean canalesSeparados) {
        if (INSTANCE == null) {
            INSTANCE = this;
            paqueteHandShake = new HandShakePacket(2, protocolVersion);
            InterfacesPlugin.plugin = plugin;
            Messenger messenger = plugin.getServer().getMessenger();
            messenger.registerOutgoingPluginChannel(plugin, CHANNEL);
            messenger.registerIncomingPluginChannel(plugin, canalesSeparados ? "pyronix:interfacessend" : CHANNEL, new PluginMessageListener(this){

                public void onPluginMessageReceived(String channel, Player player, byte[] message) {
                    if (message.length > 1) {
                        PyronixBuff buffer = PyronixBuff.wrap((byte[])message);
                        buffer.readByte();
                        RequestDispatcher.handleRequest(buffer, player);
                    }
                }
            });
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    public InterfacesPlugin(Plugin plugin, int protocolVersion) {
        this(plugin, protocolVersion, true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        ClientNetwork.enviarPaquete(event.getPlayer(), HandShakePacket.DECODEC, paqueteHandShake);
    }
}

