/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.util;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

public class BlockReference {
    public final BlockData data;
    public final Material material;
    public final Location location;

    public static BlockReference of(Block block, Location location) {
        return new BlockReference(block.getBlockData().clone(), block.getType(), location);
    }

    public static BlockReference of(Block block) {
        return new BlockReference(block.getBlockData().clone(), block.getType(), block.getLocation());
    }

    public static BlockReference of(Location location) {
        return BlockReference.of(location.getBlock(), location);
    }

    private BlockReference(BlockData data, Material material, Location location) {
        this.data = data;
        this.material = material;
        this.location = location;
    }

    public final void colocar() {
        Block block = this.location.getBlock();
        block.setType(this.material);
        block.setBlockData(this.data);
    }

    public String toString() {
        return String.format("Location: %s", this.location.toString());
    }
}

