/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.comandos;

import es.pyronixstudio.base.core.PyronixPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;

public class Argumentos {
    private List<Component> mensajes = new ArrayList<Component>();
    private boolean error = false;
    private final Audience audiencia;
    private final Object[] argumentos;
    private int puntero = 0;

    public static Argumentos of(Audience audiencia, Object ... args) {
        return new Argumentos(audiencia, args);
    }

    private Argumentos(Audience audiencia, Object ... args) {
        this.argumentos = args;
        this.audiencia = audiencia;
    }

    public boolean asError() {
        return this.error;
    }

    public <T> T asCustom(Class<T> clase) {
        return this.getInstanciaSiguiente(clase, null);
    }

    public boolean asBoolean(boolean porDefecto) {
        return this.getInstanciaSiguiente(Boolean.class, porDefecto);
    }

    public byte asByte(byte porDefecto) {
        return this.getInstanciaSiguiente(Byte.class, porDefecto);
    }

    public short asShort(short porDefecto) {
        return this.getInstanciaSiguiente(Short.class, porDefecto);
    }

    public int asInt(int porDefecto) {
        return this.getInstanciaSiguiente(Integer.class, porDefecto);
    }

    public Long asLong(long porDefecto) {
        return this.getInstanciaSiguiente(Long.class, porDefecto);
    }

    public float asFloat(float porDefecto) {
        return this.getInstanciaSiguiente(Float.class, Float.valueOf(porDefecto)).floatValue();
    }

    public double asDouble(double porDefecto) {
        return this.getInstanciaSiguiente(Double.class, porDefecto);
    }

    public String asString(String porDefecto) {
        return this.getInstanciaSiguiente(String.class, porDefecto);
    }

    public boolean asBoolean() {
        return this.asBoolean(false);
    }

    public byte asByte() {
        return this.asByte((byte)0);
    }

    public short asShort() {
        return this.asShort((short)0);
    }

    public int asInt() {
        return this.asInt(0);
    }

    public Long asLong() {
        return this.asLong(0L);
    }

    public float asFloat() {
        return this.asFloat(0.0f);
    }

    public double asDouble() {
        return this.asDouble(0.0);
    }

    public String asString() {
        return this.asString("");
    }

    private Object next() {
        Object siguiente = this.argumentos[this.puntero];
        if (this.puntero + 1 < this.argumentos.length) {
            ++this.puntero;
        }
        return siguiente;
    }

    private <T> T getInstanciaSiguiente(Class<T> clase, T porDefecto) {
        Object casteo = null;
        try {
            casteo = clase.cast(this.next());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)(casteo == null ? porDefecto : casteo);
    }

    public void addErrorMensaje(String mensaje) {
        this.error = true;
        this.addMensaje(String.format("<red>%s", mensaje));
    }

    public void addErrores(Collection<Component> mensajes) {
        if (mensajes == null || mensajes.isEmpty()) {
            return;
        }
        this.error = true;
        mensajes.forEach(component -> this.mensajes.add((Component)component));
    }

    public void addMensaje(String mensaje) {
        this.mensajes.add(PyronixPlugin.format(mensaje));
    }

    public void enviarMensaje(String mensaje) {
        this.audiencia.sendMessage(PyronixPlugin.format(mensaje));
    }

    public void enviarMensajes() {
        this.mensajes.forEach(arg_0 -> ((Audience)this.audiencia).sendMessage(arg_0));
    }
}

