/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa;

import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.core.RutasBase;
import es.pyronixstudio.base.juego.mapa.MarcadorConfiguracion;
import es.pyronixstudio.base.juego.mapa.TipoMarcador;
import es.pyronixstudio.base.juego.mapa.serializador.Marcadores;
import es.pyronixstudio.base.juego.mapa.serializador.SerializadorBloqueManager;
import es.pyronixstudio.base.util.Ubicacion;
import es.pyronixstudio.util.ficheros.Elemento;
import es.pyronixstudio.util.ficheros.FicheroBase;
import es.pyronixstudio.util.ficheros.PyronixFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public abstract class AbstractConfiguracionMapa {
    protected final Path carpeta;
    protected final PyronixFile config;
    public final PyronixFile configExtra;
    protected Elemento propiedades;
    protected Location esquina1;
    protected Location esquina2;
    private final String nombre;
    private final Set<Material> bloquesIgnoradosReset;
    private final Set<Material> bloquesReset;
    public static final BlockFace[] CARAS = new BlockFace[]{BlockFace.DOWN, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.UP};

    public AbstractConfiguracionMapa(String nombreMapa) {
        this.nombre = nombreMapa;
        this.carpeta = RutasBase.MAPA_CARPETA.apply(nombreMapa);
        this.config = RutasBase.MAPA_CONFIG_FICHERO.apply(this.carpeta);
        this.configExtra = RutasBase.MAPA_CONFIG_EXTRA_FICHERO.apply(this.carpeta);
        this.bloquesIgnoradosReset = this.getBloquesIgnoradosResetFichero();
        this.bloquesReset = this.getBloquesParaReset();
        this.leerPropiedades();
    }

    public void borrar() {
        PyronixFile.of((Path)this.carpeta).borrar();
    }

    private void leerPropiedades() {
        if (this.configExtra.existe()) {
            this.configExtra.parsear();
        }
        if (!this.config.existe()) {
            return;
        }
        this.config.parsear();
        this.propiedades = this.config.getElemento("propiedades");
        this.esquina1 = Ubicacion.getLocation(this.propiedades);
        this.esquina2 = Ubicacion.getLocation(this.propiedades, "2");
        this.leerPropiedadesExtra();
    }

    public void crear(Location esquina1, Location esquina2) {
        PyronixFile configExtra = RutasBase.MAPA_CONFIG_EXTRA_FICHERO.apply(this.carpeta);
        ArrayList<Elemento> configExtraAGenerar = new ArrayList<Elemento>();
        this.crearPropiedadesExtra(configExtraAGenerar);
        configExtra.agregarTodo(configExtraAGenerar);
        configExtra.serializar();
        PyronixFile config = RutasBase.MAPA_CONFIG_FICHERO.apply(this.carpeta);
        ArrayList<Elemento> configAGenerar = new ArrayList<Elemento>();
        this.crearPropiedadesBasicas(configAGenerar, esquina1, esquina2);
        this.crearPropiedadesBasicasExtra(configAGenerar);
        config.agregarTodo(configAGenerar);
        config.serializar();
        PyronixFile.copiarFichero((String)"marcadores", (PyronixFile)RutasBase.MAPA_MARCADOR_CONFIG_FICHERO.apply(this.carpeta), (String[])new String[]{"mapas"});
    }

    protected void crearPropiedadesExtra(List<Elemento> config) {
    }

    protected abstract void crearPropiedadesBasicasExtra(List<Elemento> var1);

    private void crearPropiedadesBasicas(List<Elemento> config, Location esquina1, Location esquina2) {
        Elemento elemento = Elemento.empty((String)"propiedades");
        Ubicacion.escribir(elemento, esquina1, true);
        Ubicacion.escribir(elemento, esquina2, "2");
        elemento.add("edicion", (Object)false);
        config.add(elemento);
    }

    public void tpJugador(Player player) {
        player.teleport(Ubicacion.mitad(this.esquina1, this.esquina2));
        player.sendMessage(PyronixPlugin.format(String.format("<green>Usted se teletransporto a %s", this.nombre)));
    }

    public final void modoEditor(Player player) {
        List<MarcadorConfiguracion> marcadores = this.obtenerConfiguracionMarcadores();
        if (!this.isModoEditorEnabled()) {
            if (PyronixPlugin.INSTANCE.partidaManager.mapaEnPartida(this.nombre)) {
                player.sendMessage(PyronixPlugin.format(String.format("<red>Lo siento el Mapa <green>%s <red>esta en partida", this.nombre)));
                return;
            }
            this.setModoEditor(true);
            this.config.serializar();
            marcadores.forEach(MarcadorConfiguracion::colocar);
            player.sendMessage(PyronixPlugin.format(String.format("<green>Modo editor activo del mapa %s", this.nombre)));
        }
        this.darMarcadoresItemSack(player, marcadores);
    }

    protected List<MarcadorConfiguracion> obtenerConfiguracionMarcadores() {
        PyronixFile configEditor = RutasBase.MAPA_MARCADOR_CONFIG_FICHERO.apply(this.carpeta);
        configEditor.parsear();
        ArrayList<MarcadorConfiguracion> marcadores = new ArrayList<MarcadorConfiguracion>();
        List marcadoresLeidos = configEditor.getIds();
        for (String id : marcadoresLeidos) {
            marcadores.add(new MarcadorConfiguracion(configEditor.getElemento(id), this.config.getElemento(MarcadorConfiguracion.idConPrefijo(id)), this.getMundo()));
        }
        this.config.getElementoQueContenga("m").forEach(marcador -> {
            if (!marcadoresLeidos.contains(marcador.id)) {
                this.config.borrarElemento(marcador);
            }
        });
        return marcadores;
    }

    protected final Map<Material, MarcadorConfiguracion> obtenerMarcadoresPorMaterial() {
        List<MarcadorConfiguracion> marcadores = this.obtenerConfiguracionMarcadores();
        HashMap<Material, MarcadorConfiguracion> marcadoresPorMaterial = new HashMap<Material, MarcadorConfiguracion>();
        for (MarcadorConfiguracion marcador : marcadores) {
            marcadoresPorMaterial.put(marcador.material, marcador);
        }
        return marcadoresPorMaterial;
    }

    protected final Marcadores obtenerMarcadoresPorTipo() {
        List<MarcadorConfiguracion> marcadores = this.obtenerConfiguracionMarcadores();
        HashMap<TipoMarcador, List<MarcadorConfiguracion>> marcadoresPorTipo = new HashMap<TipoMarcador, List<MarcadorConfiguracion>>();
        for (MarcadorConfiguracion marcador : marcadores) {
            marcadoresPorTipo.computeIfAbsent(marcador.tipoMarcador, k -> new ArrayList()).add(marcador);
        }
        return Marcadores.of(marcadoresPorTipo);
    }

    private void darMarcadoresItemSack(Player player, List<MarcadorConfiguracion> marcadores) {
        PlayerInventory inv = player.getInventory();
        inv.clear();
        if (marcadores != null) {
            marcadores.forEach(marcador -> inv.addItem(new ItemStack[]{marcador.stack}));
            player.sendMessage(PyronixPlugin.format(String.format("<green>Se le dio los items marcadores del mapa %s", this.nombre)));
        }
    }

    public void guardar(Player player) {
        Map<Material, MarcadorConfiguracion> marcadores = this.obtenerMarcadoresPorMaterial();
        marcadores.values().forEach(marcador -> marcador.borrar());
        ArrayList lineasReset = new ArrayList();
        boolean reseteable = this.isReseteable();
        SerializadorBloqueManager serializador = new SerializadorBloqueManager();
        this.ejecutarFuncionEnBloquesMapa(bloque -> {
            Material tipo = bloque.getType();
            MarcadorConfiguracion marcador = (MarcadorConfiguracion)marcadores.get(tipo);
            if (marcador != null) {
                marcador.agregarUbicacionSiNoExiste((Block)bloque);
                if (!marcador.reseteable) {
                    return;
                }
            }
            if (!reseteable) {
                return;
            }
            this.serializarBloqueSiEsValido(lineasReset, (Block)bloque, serializador);
        });
        this.setModoEditor(false);
        marcadores.values().forEach(marcador -> marcador.guardar(this.config));
        this.config.serializar();
        if (reseteable) {
            FicheroBase fichero = RutasBase.MAPA_RESET_FICHERO.apply(this.carpeta);
            fichero.escribirLineas(lineasReset);
        }
        this.darMarcadoresItemSack(player, null);
    }

    private void serializarBloqueSiEsValido(List<String> lineasReset, Block block, SerializadorBloqueManager serializador) {
        Material tipo = block.getType();
        if (this.bloquesReset.contains(tipo)) {
            return;
        }
        if (this.tieneBloqueReset(block)) {
            serializador.serializar(lineasReset, block);
        }
    }

    private boolean tieneBloqueReset(Block bloque) {
        Material tipo = bloque.getType();
        if (this.bloquesIgnoradosReset.contains(tipo) || tipo == Material.AIR) {
            return false;
        }
        for (BlockFace cara : CARAS) {
            Block bloqueAdyacente = bloque.getRelative(cara);
            Material tipoBloqueAdyacente = bloqueAdyacente.getType();
            if (!this.bloquesReset.contains(tipoBloqueAdyacente)) continue;
            return true;
        }
        return false;
    }

    private void ejecutarFuncionEnBloquesMapa(Consumer<Block> bloqueConsumer) {
        Ubicacion.EsquinasLocationRecord esquinas = Ubicacion.getLocacionCoordsMenorMayor(this.esquina1, this.esquina2);
        for (int x = esquinas.menorX; x <= esquinas.maxX; ++x) {
            for (int y = esquinas.menorY; y <= esquinas.maxY; ++y) {
                for (int z = esquinas.menorZ; z <= esquinas.maxZ; ++z) {
                    Block bloque = esquinas.world.getBlockAt(x, y, z);
                    if (bloque.getType() == Material.AIR) continue;
                    bloqueConsumer.accept(bloque);
                }
            }
        }
    }

    private void setModoEditor(boolean activar) {
        this.propiedades.add("edicion", (Object)activar);
        Material esquinas = activar ? Material.DIAMOND_BLOCK : Material.AIR;
        this.esquina1.getBlock().setType(esquinas);
        this.esquina2.getBlock().setType(esquinas);
    }

    public boolean isModoEditorEnabled() {
        return this.propiedades.get("edicion").asBoolean();
    }

    private Set<Material> getBloquesIgnoradosResetFichero() {
        HashSet<Material> material = new HashSet<Material>();
        this.getBloquesIgnoradosResetFicheroExtra(material);
        return material;
    }

    private Set<Material> getBloquesParaReset() {
        HashSet<Material> material = new HashSet<Material>();
        material.add(Material.BEDROCK);
        material.add(Material.STRUCTURE_VOID);
        this.getBloquesParaResetExtra(material);
        return material;
    }

    public void reset() {
        this.reset(null);
    }

    public void reset(Material bloque) {
        if (!this.isReseteable()) {
            return;
        }
        FicheroBase ficheroReset = RutasBase.MAPA_RESET_FICHERO.apply(this.carpeta);
        SerializadorBloqueManager deserializador = new SerializadorBloqueManager();
        World world = this.getMundo();
        ficheroReset.ejecutarFuncionACadaLinea(linea -> deserializador.deserializar((String)linea, world, bloque));
    }

    protected abstract void getBloquesIgnoradosResetFicheroExtra(Set<Material> var1);

    protected abstract void getBloquesParaResetExtra(Set<Material> var1);

    public World getMundo() {
        return (World)this.propiedades.get("mundo").asCustom(Bukkit::getWorld);
    }

    protected abstract void leerPropiedadesExtra();

    public abstract boolean isReseteable();
}

