/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.puntuaciones;

import es.pyronixstudio.base.core.PyronixScheduler;
import es.pyronixstudio.base.juego.equipo.EnumColor;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.EnumEstadoPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.juego.puntuaciones.AbstractPuntuacion;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.scheduler.BukkitTask;

public abstract class AbstractPuntuacionManager
implements IReseteable {
    protected Map<EnumColor, AbstractPuntuacion> puntuaciones = new HashMap<EnumColor, AbstractPuntuacion>();
    protected AbstractPartida<?, ?, ?> partida;
    private final boolean actulizarTrasSuma;
    protected BukkitTask actualizarTask = null;

    public AbstractPuntuacionManager(AbstractPartida<?, ?, ?> partida, boolean actulizarTrasSuma) {
        this.partida = partida;
        this.actulizarTrasSuma = actulizarTrasSuma;
    }

    public void sumarActual(EnumColor color, int aSumar) {
        this.ejecutarSiExiste(color, puntuacion -> puntuacion.sumarActual(aSumar));
    }

    public void sumarGlobal(EnumColor color, int aSumar) {
        this.ejecutarSiExiste(color, puntuacion -> puntuacion.sumarGlobal(aSumar));
    }

    private AbstractPuntuacion crearPuntuacionSiNoExiste(EnumColor color) {
        return this.puntuaciones.computeIfAbsent(color, k -> this.getPuntuacionSupplier().get());
    }

    protected abstract Supplier<AbstractPuntuacion> getPuntuacionSupplier();

    protected abstract void actualizarUI();

    protected void programarActualizarUI(int ticks) {
        PyronixScheduler.runTaskTimer(0L, ticks, task -> {
            if (this.partida.getEstado().haSuperadoOEstaEnEstado(EnumEstadoPartida.INICIADA)) {
                return;
            }
            this.actualizarUI();
        });
    }

    private void ejecutarSiExiste(EnumColor color, Consumer<AbstractPuntuacion> puntuacionEncontrada) {
        Objects.requireNonNull(color);
        AbstractPuntuacion puntuacion = this.crearPuntuacionSiNoExiste(color);
        if (puntuacion != null) {
            puntuacionEncontrada.accept(puntuacion);
        }
        if (this.actulizarTrasSuma) {
            this.actualizarUI();
        }
    }

    protected abstract void partidaTerminada();

    @Override
    public boolean reset(AbstractPartida<?, ?, ?> partida) {
        for (AbstractPuntuacion puntuacion : this.puntuaciones.values()) {
            puntuacion.reset(partida);
        }
        return true;
    }

    @Override
    public void resetCompleto(AbstractPartida<?, ?, ?> partida) {
        if (this.actualizarTask != null) {
            this.actualizarTask.cancel();
        }
        this.puntuaciones.clear();
    }

    public String toString() {
        return String.format("{[AbstractPuntuacionManager] actualizarTask:%s, actulizarTrasSuma:%s, puntuaciones:%s}", this.actualizarTask, this.actulizarTrasSuma, this.puntuaciones);
    }
}

