/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.areas;

import es.pyronixstudio.base.componentes.SistemaComponente;
import es.pyronixstudio.base.juego.ITickable;
import es.pyronixstudio.base.juego.areas.AreaErrores;
import es.pyronixstudio.base.juego.areas.AreasManager;
import es.pyronixstudio.base.juego.areas.BaseParticulasHelperAreas;
import es.pyronixstudio.base.juego.areas.IAreaRenderable;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.equipo.EnumColor;
import es.pyronixstudio.base.juego.items.contextos.ItemExecutionContext;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.registros.tipo.IRegistro;
import es.pyronixstudio.base.util.Ubicacion;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.ficheros.Valor;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public abstract class Area<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
implements IReseteable {
    public Ubicacion.EsquinasLocationRecord esquinas;
    protected final Set<J> jugadoresDentro = new HashSet<J>();
    protected final Valor[] args;
    protected final P partida;
    protected final SistemaComponente componentSystem;
    protected final Location centro;
    public final int maxTicks;
    private final int areaX;
    private final int areaY;
    private final int areaZ;
    private final AreasManager<?, ?, ?> manager;
    private final boolean onlyTickTeamColor;
    private final Wrapper<BaseParticulasHelperAreas> renderableHelper = Wrapper.emptyUnmodifiable();

    public Area(Builder builder) {
        this.args = builder.args;
        this.esquinas = builder.esquinas;
        this.partida = (AbstractPartida)CastUtil.cast(builder.partida);
        this.componentSystem = builder.componentSystem;
        this.centro = builder.centro;
        this.maxTicks = builder.maxTicks;
        this.areaX = builder.areaX;
        this.areaY = builder.areaY;
        this.areaZ = builder.areaZ;
        this.manager = builder.areasManager;
        this.onlyTickTeamColor = builder.onlyTickTeam;
        ((AbstractPartida)this.partida).resetManager.agregarObjeto(this);
    }

    public void registrarParticulas() {
        Area area = this;
        if (area instanceof IAreaRenderable) {
            IAreaRenderable renderable = (IAreaRenderable)((Object)area);
            renderable.setParticleHelper(this.renderableHelper);
        }
    }

    private void remove(J jugador) {
        boolean borrado = this.jugadoresDentro.remove(jugador);
        if (borrado) {
            this.onExit(jugador);
        }
    }

    private void add(J jugador) {
        boolean agregado = this.jugadoresDentro.add(jugador);
        if (agregado) {
            this.onEnter(jugador);
        }
    }

    private void updateArea() {
        Entity entidad = (Entity)this.componentSystem.get(RegistrosBase.COMPONENTES.ENTIDAD_TRACKEADA_AREA);
        if (entidad != null) {
            if (!entidad.isValid()) {
                this.desregistrar();
                return;
            }
            Location nuevaUbicacion = entidad.getLocation();
            this.esquinas = Ubicacion.getEsquinarRelativa(nuevaUbicacion, this.areaX, this.areaY, this.areaZ);
            this.renderableHelper.ifPresent(BaseParticulasHelperAreas::update);
        }
    }

    public final void comprobarColisiones() {
        this.updateArea();
        if (!this.onlyTickTeamColor) {
            ((AbstractPartida)this.partida).jugadorManager.ejecutarFuncionTodosLosJugadores(this::estaEnArea);
        } else {
            EnumColor color = (EnumColor)((Object)this.componentSystem.get(RegistrosBase.COMPONENTES.COLOR));
            if (color == null) {
                this.desregistrar();
                throw new AreaErrores.MissingTeamForOnlyTeamTickAreaException();
            }
            ((AbstractEquipo)((AbstractPartida)this.partida).equipoManager.get(color).get()).ejecutarFuncionTodosLosJugadores(this::estaEnArea);
        }
        this.renderableHelper.ifPresent(BaseParticulasHelperAreas::tick);
        ITickable.tickIfInstance(this);
    }

    private void estaEnArea(J jugador) {
        Player player = ((AbstractJugador)jugador).getMinecraftPlayer();
        Location location = player.getLocation();
        if (!location.getWorld().equals((Object)this.esquinas.world) && !((AbstractJugador)jugador).esMinecraftPlayerValido()) {
            this.remove(jugador);
            return;
        }
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        if (!player.isDead() && x <= this.esquinas.maxX && x >= this.esquinas.menorX && y <= this.esquinas.maxY && y >= this.esquinas.menorY && z <= this.esquinas.maxZ && z >= this.esquinas.menorZ) {
            this.add(jugador);
            return;
        }
        this.remove(jugador);
    }

    protected void desregistrar() {
        this.manager.remove(this.centro);
    }

    protected abstract void onEnter(J var1);

    protected abstract void onExit(J var1);

    protected void alDesregistrarse() {
    }

    public String toString() {
        return String.format("Area=[Esquinas:%s, Jugadores:%s, Args:%s, MaxTicks:%s]", this.esquinas, this.jugadoresDentro, this.args, this.maxTicks);
    }

    private static Optional<Builder> newBuilder(Function<Builder, Area<?, ?, ?>> constructor, AbstractPartida<?, ?, ?> partida) {
        if (constructor == null) {
            return Optional.empty();
        }
        return Optional.of(new Builder(constructor, partida));
    }

    public static Optional<Builder> newBuilder(IRegistro<Function<Builder, Area<?, ?, ?>>> registroArea, AbstractPartida<?, ?, ?> partida) {
        if (registroArea.isEmpty()) {
            return Optional.empty();
        }
        return Area.newBuilder(registroArea.crear(), partida);
    }

    public static Optional<Builder> newBuilder(IRegistro<Function<Builder, Area<?, ?, ?>>> supplierConstructor, AbstractJugador<?, ?, ?> jugador) {
        return Area.newBuilder(supplierConstructor, jugador.getEquipo());
    }

    public static Optional<Builder> newBuilder(IRegistro<Function<Builder, Area<?, ?, ?>>> supplierConstructor, ItemExecutionContext<?, ?, ?> contexto) {
        return Area.newBuilder(supplierConstructor, contexto.jugadorEjecutor);
    }

    public static Optional<Builder> newBuilder(IRegistro<Function<Builder, Area<?, ?, ?>>> supplierConstructor, AbstractEquipo<?, ?, ?> equipo) {
        return Area.newBuilder(supplierConstructor.crear(), equipo.partida);
    }

    public static class Builder {
        private Valor[] args = new Valor[0];
        private Location centro;
        private Ubicacion.EsquinasLocationRecord esquinas;
        private final Function<Builder, Area<?, ?, ?>> constructor;
        private final AbstractPartida<?, ?, ?> partida;
        public final SistemaComponente componentSystem = SistemaComponente.create();
        private int maxTicks = -1;
        private AreasManager<?, ?, ?> areasManager;
        private boolean onlyTickTeam = false;
        private Location esquina1;
        private Location esquina2;
        private int areaX;
        private int areaY;
        private int areaZ;

        private Builder(Function<Builder, Area<?, ?, ?>> constructor, AbstractPartida<?, ?, ?> partida) {
            this.constructor = constructor;
            this.partida = partida;
        }

        public Builder set(int area) {
            return this.set(area, area, area);
        }

        public Builder set(int areaX, int areaY, int areaZ) {
            this.areaX = areaX;
            this.areaY = areaY;
            this.areaZ = areaZ;
            return this;
        }

        public Builder set(Location esquina, Location esquina2) {
            this.esquina1 = esquina;
            this.esquina2 = esquina2;
            return this;
        }

        public Builder setCentro(Location centro) {
            this.centro = centro;
            return this;
        }

        public Builder maxTicks(int maxTicks) {
            this.maxTicks = maxTicks;
            return this;
        }

        public Builder args(Valor[] args) {
            this.args = args;
            return this;
        }

        public Builder setAreaManager(AreasManager<?, ?, ?> areasManager) {
            this.areasManager = areasManager;
            return this;
        }

        public Builder setTrackedEntity(Entity entity) {
            this.componentSystem.add(RegistrosBase.COMPONENTES.ENTIDAD_TRACKEADA_AREA, entity);
            return this;
        }

        public Builder setOnlyTickTeam() {
            this.onlyTickTeam = true;
            return this;
        }

        public final Area<?, ?, ?> build() {
            this.esquinas = this.esquina1 == null || this.esquina2 == null ? Ubicacion.getEsquinarRelativa(this.centro, this.areaX, this.areaY, this.areaZ) : Ubicacion.getLocacionCoordsMenorMayor(this.esquina1, this.esquina2);
            Area<?, ?, ?> area = this.constructor.apply(this);
            area.registrarParticulas();
            return area;
        }
    }
}

