/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.items.contextos;

import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.items.ItemManager;
import es.pyronixstudio.base.juego.items.contextos.ItemExecutionContext;
import es.pyronixstudio.base.juego.items.contextos.ItemUseContext;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;

public class ItemHitContext<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
extends ItemExecutionContext<J, E, P> {
    private final EnumHitType hitType;
    public final ItemUseContext.EnumUseType useType;
    public final Projectile projectile;
    private Block hitBlock;
    private BlockFace hitBlockFace;
    private Entity hitEntity;

    public ItemHitContext(ItemManager<J, E, P> itemManager, J jugadorEjecutor, String idItemPersonalizado, ItemUseContext.EnumUseType useType, Projectile projectile, Block hitBlock, BlockFace blockFace) {
        this(itemManager, jugadorEjecutor, idItemPersonalizado, EnumHitType.BLOCK, useType, projectile);
        this.hitBlock = hitBlock;
        this.hitBlockFace = blockFace;
    }

    public ItemHitContext(ItemManager<J, E, P> itemManager, J jugadorEjecutor, String idItemPersonalizado, ItemUseContext.EnumUseType useType, Projectile projectile, Entity hitEntity) {
        this(itemManager, jugadorEjecutor, idItemPersonalizado, EnumHitType.ENTITY, useType, projectile);
        this.hitEntity = hitEntity;
    }

    private ItemHitContext(ItemManager<J, E, P> itemManager, J jugadorEjecutor, String idItemPersonalizado, EnumHitType hitType, ItemUseContext.EnumUseType useType, Projectile projectile) {
        super(itemManager, jugadorEjecutor, idItemPersonalizado, ItemExecutionContext.ContextExecutionType.HIT);
        this.hitType = hitType;
        this.useType = useType;
        this.projectile = projectile;
        this.disableCooldown();
    }

    public boolean isHitBlock() {
        return this.hitType == EnumHitType.BLOCK;
    }

    public boolean isHitEntity() {
        return this.hitType == EnumHitType.ENTITY;
    }

    public Block getHitBlock() {
        return this.hitBlock;
    }

    public Entity getHitEntity() {
        return this.hitEntity;
    }

    public Location getHitLocation() {
        Location location = this.isHitBlock() ? this.hitBlock.getLocation() : this.hitEntity.getLocation();
        return location;
    }

    private static enum EnumHitType {
        BLOCK,
        ENTITY;

    }
}

