/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.partida;

import es.pyronixstudio.base.core.PyronixScheduler;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public abstract class AbstractTiempoManager<P extends AbstractPartida<?, ?, ?>>
implements IReseteable {
    protected P partida;
    protected PyronixScheduler.PyronixTask tareaCronometro;
    protected boolean tickear = true;
    protected int tiempoActual = 0;
    private final int suma;

    protected AbstractTiempoManager(P partida, int empezarEn, boolean inverso) {
        this.partida = partida;
        this.suma = inverso ? -1 : 1;
        this.tiempoActual = empezarEn;
    }

    public final void partidaIniciada() {
        this.tareaCronometro = PyronixScheduler.runTaskTimer(0L, 20L, task -> {
            if (task.isCancelled()) {
                return;
            }
            this.mostrarTimer(this.tiempoActual);
            this.preTickCronometro();
            if (this.tickear) {
                this.tickCronometro();
                this.tiempoActual += this.suma;
            }
        });
    }

    protected abstract void preTickCronometro();

    protected abstract void tickCronometro();

    public void finalizarPartida() {
        if (this.tareaCronometro != null) {
            this.tareaCronometro.cancel();
        }
        ((AbstractPartida)this.partida).terminar();
    }

    @Override
    public boolean reset(AbstractPartida<?, ?, ?> partida) {
        if (this.tareaCronometro != null) {
            this.tareaCronometro.cancel();
            this.tareaCronometro = null;
        }
        this.tiempoActual = 0;
        return false;
    }

    private void mostrarTimer(int segundos) {
        for (AbstractJugador jugador : ((AbstractPartida)this.partida).jugadorManager.getAll()) {
            Player player = jugador.getMinecraftPlayer();
            if (player == null || !player.isOnline()) continue;
            String horas = String.format("%02d:", segundos / 3600);
            Object resultado = String.format("%02d:%02d", segundos % 3600 / 60, segundos % 60);
            if (!horas.equals("00:")) {
                resultado = horas + (String)resultado;
            }
            player.sendActionBar((Component)Component.text((String)resultado));
        }
    }
}

