/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.equipo;

import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.equipo.EnumColor;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class EquipoManager<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>> {
    private final Map<EnumColor, E> equipos = new HashMap<EnumColor, E>();

    public final E agregar(EnumColor color, E equipo) {
        return (E)this.equipos.computeIfAbsent(color, k -> equipo);
    }

    public final Wrapper<E> get(EnumColor equipo) {
        return Wrapper.of((Object)((AbstractEquipo)this.equipos.get((Object)equipo)));
    }

    public final Collection<E> getAll() {
        return this.equipos.values();
    }

    public final List<E> filtrar(Predicate<? super E> predicado) {
        return this.getAll().stream().filter(predicado).collect(Collectors.toCollection(ArrayList::new));
    }

    public final boolean hayColor(EnumColor color) {
        return this.getColores().contains((Object)color);
    }

    public final Collection<EnumColor> getColores() {
        return this.equipos.keySet();
    }

    public final int getCantidad() {
        return this.equipos.size();
    }

    public final void ejecutarFuncionTodosLosEquipos(Consumer<E> equipoConsumer) {
        this.getAll().forEach(equipoConsumer);
    }

    public final void remove(EnumColor color) {
        if (this.hayColor(color)) {
            this.equipos.remove((Object)color);
        }
    }

    public final void removeAll() {
        this.getAll().forEach(AbstractEquipo::borrarJugadores);
        this.equipos.clear();
    }
}

