/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.registros;

import es.pyronixstudio.base.juego.equipo.EnumColor;
import es.pyronixstudio.base.registros.tipo.IRegistro;
import es.pyronixstudio.base.registros.tipo.Registro;
import es.pyronixstudio.base.registros.tipo.RegistroMultipleRandom;
import es.pyronixstudio.base.registros.tipo.RegistroPesosRandom;
import es.pyronixstudio.util.ficheros.Valor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class RegistradorBase<E> {
    private final Map<String, IRegistro<E>> ELEMENTOS = new HashMap<String, IRegistro<E>>();

    protected IRegistro<E> registrarElemento(String identificador, Supplier<E> supplier) {
        return this.ELEMENTOS.computeIfAbsent(identificador.toLowerCase(), k -> Registro.of(supplier));
    }

    protected IRegistro<E> registrarElemento(String identificador, Function<String, E> consumidor) {
        return this.ELEMENTOS.computeIfAbsent(identificador.toLowerCase(), k -> Registro.of(identificador, consumidor));
    }

    protected IRegistro<E> registrarElementoRandom(String identificador, List<IRegistro<E>> identificadores) {
        return this.ELEMENTOS.computeIfAbsent(identificador.toLowerCase(), k -> RegistroMultipleRandom.of(identificadores));
    }

    protected IRegistro<E> registrarElementoRandom(String identificador, Map<IRegistro<E>, Integer> identificadoresPeso) {
        return this.ELEMENTOS.computeIfAbsent(identificador.toLowerCase(), k -> RegistroPesosRandom.of(identificadoresPeso));
    }

    protected IRegistro<E> registrarElemento(Enum<?> enumObject, Supplier<E> supplier) {
        return this.registrarElemento(enumObject.name(), supplier);
    }

    public IRegistro<E> get(String identificador) {
        Objects.requireNonNull(identificador);
        IRegistro<E> registroObtenido = this.ELEMENTOS.get(identificador.toLowerCase());
        if (registroObtenido != null) {
            return registroObtenido;
        }
        return Registro.empty();
    }

    public IRegistro<E> get(Enum<?> enumObject) {
        return this.get(enumObject.name());
    }

    public IRegistro<E> get(Valor identificador) {
        String valorString = identificador == null ? "" : identificador.asString();
        return this.get(valorString);
    }

    public IRegistro<E> getPorColorSuffix(String suffix, EnumColor color) {
        return this.get(String.format("%s%s", color.name(), suffix));
    }

    public Map<String, IRegistro<E>> getElementos() {
        return this.ELEMENTOS;
    }

    public <K, V> Map<K, V> getElementos(Function<String, K> transformarClave, Function<E, V> transformarValor) {
        Map<String, IRegistro<E>> mapaElementos = this.getElementos();
        HashMap mapaDevolver = new HashMap();
        mapaElementos.forEach((clave, valor) -> {
            Object claveTransformada = transformarClave.apply((String)clave);
            Object valorTransformado = transformarValor.apply(valor.crear());
            mapaDevolver.put(claveTransformada, valorTransformado);
        });
        return mapaDevolver;
    }

    public IRegistro<E> get(int indentificador) {
        return this.get(Integer.toString(indentificador));
    }

    public abstract Class<?> getKeyClass();
}

