/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa.serializador;

import es.pyronixstudio.base.componentes.Componente;
import es.pyronixstudio.base.juego.equipo.EnumColor;
import es.pyronixstudio.base.juego.equipo.EquipoManager;
import es.pyronixstudio.base.juego.mapa.MarcadorConfiguracion;
import es.pyronixstudio.base.juego.mapa.TipoMarcador;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.registros.tipo.IRegistro;
import es.pyronixstudio.util.EnumUtil;
import es.pyronixstudio.util.ExitoHandler;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class Marcadores {
    private AbstractPartida<?, ?, ?> partida;
    protected final Map<TipoMarcador, List<MarcadorConfiguracion>> marcadoresPorTipo;

    public static Marcadores of(Map<TipoMarcador, List<MarcadorConfiguracion>> marcadoresPorTipo) {
        return new Marcadores(marcadoresPorTipo);
    }

    private Marcadores(Map<TipoMarcador, List<MarcadorConfiguracion>> marcadoresPorTipo) {
        this.marcadoresPorTipo = marcadoresPorTipo;
    }

    public void setPartida(AbstractPartida<?, ?, ?> partida) {
        this.partida = partida;
    }

    public List<MarcadorConfiguracion> get(IRegistro<TipoMarcador> tipoSupplier) {
        return this.get(tipoSupplier.crear());
    }

    public List<MarcadorConfiguracion> getOrEmpty(IRegistro<TipoMarcador> tipoSupplier) {
        List<MarcadorConfiguracion> marcadoresObtenidos = this.get(tipoSupplier);
        return marcadoresObtenidos != null ? marcadoresObtenidos : List.of();
    }

    private List<MarcadorConfiguracion> get(TipoMarcador tipoSupplier) {
        return this.marcadoresPorTipo.get(tipoSupplier);
    }

    public <T> void setComponente(IRegistro<TipoMarcador> tipoMarcador, IRegistro<Componente<T>> componente, Function<MarcadorConfiguracion, T> funcion) {
        if (this.partida == null) {
            throw new IllegalStateException("No se puede obtener EquipoManager porque partida es Nula, por eso no se puede poner los componentes a los equipos.");
        }
        EquipoManager equipoManager = this.partida.equipoManager;
        List<MarcadorConfiguracion> marcadores = this.get(tipoMarcador);
        for (MarcadorConfiguracion marcador : marcadores) {
            EnumColor color = (EnumColor)((Object)EnumUtil.valueOfSecure(EnumColor.class, (String)marcador.config.get("color").asString()));
            if (color == null) {
                return;
            }
            Object valorComponente = funcion.apply(marcador);
            equipoManager.get(color).ifPresent(equipo -> equipo.componentSystem.add(componente, valorComponente));
        }
    }

    public ExitoHandler ejecutarEnTipo(IRegistro<TipoMarcador> tipoSupplier, Consumer<MarcadorConfiguracion> consumidor) {
        if (tipoSupplier == null) {
            return ExitoHandler.terminado((boolean)false);
        }
        return this.ejecutarEnTipo(tipoSupplier.crear(), consumidor);
    }

    public ExitoHandler ejecutarEnTipo(TipoMarcador tipo, Consumer<MarcadorConfiguracion> consumidor) {
        if (consumidor == null) {
            return ExitoHandler.terminado((boolean)false);
        }
        List<MarcadorConfiguracion> marcadores = this.marcadoresPorTipo.get(tipo);
        if (marcadores == null || marcadores.isEmpty()) {
            return ExitoHandler.terminado((boolean)false);
        }
        marcadores.forEach(consumidor);
        return ExitoHandler.terminado((boolean)true);
    }
}

