/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.registros;

import es.pyronixstudio.base.componentes.Componente;
import es.pyronixstudio.base.core.exceptions.Exception;
import es.pyronixstudio.base.estructuras.Patron;
import es.pyronixstudio.base.juego.areas.Area;
import es.pyronixstudio.base.juego.bloques.IAccionBloque;
import es.pyronixstudio.base.juego.entidades.AccionEntidad;
import es.pyronixstudio.base.juego.items.AccionItem;
import es.pyronixstudio.base.juego.mapa.TipoMarcador;
import es.pyronixstudio.base.juego.mapa.generadores.condiciones.Condicion;
import es.pyronixstudio.base.registros.RegistradorAccionesBloquesBase;
import es.pyronixstudio.base.registros.RegistradorAccionesEntidadesBase;
import es.pyronixstudio.base.registros.RegistradorAccionesItemsBase;
import es.pyronixstudio.base.registros.RegistradorBase;
import es.pyronixstudio.base.registros.RegistradorComponentesBase;
import es.pyronixstudio.base.registros.RegistradorCondicionesGeneradorBase;
import es.pyronixstudio.base.registros.RegistradorCreadorAreasBase;
import es.pyronixstudio.base.registros.RegistradorDisplayTransformacionesBase;
import es.pyronixstudio.base.registros.RegistradorErroresBase;
import es.pyronixstudio.base.registros.RegistradorPatronBase;
import es.pyronixstudio.base.registros.RegistradorSonidosBase;
import es.pyronixstudio.base.registros.RegistradorTiposMarcadoresBase;
import es.pyronixstudio.base.sonido.SonidoBase;
import es.pyronixstudio.util.CastUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.bukkit.entity.Display;

public class RegistrosBase {
    public static RegistradorComponentesBase COMPONENTES;
    public static RegistradorSonidosBase SONIDOS;
    public static RegistradorAccionesItemsBase ACCIONES_ITEMS;
    public static RegistradorAccionesBloquesBase ACCIONES_BLOQUES;
    public static RegistradorAccionesEntidadesBase ACCIONES_ENTIDADES;
    public static RegistradorCreadorAreasBase CREADOR_AREAS;
    public static RegistradorCondicionesGeneradorBase CONDICIONES_GENERADORES;
    public static RegistradorTiposMarcadoresBase TIPO_MARCADORES;
    public static RegistradorPatronBase PATRONES;
    public static RegistradorDisplayTransformacionesBase DISPLAY_TRANSFORMACIONES;
    public static RegistradorErroresBase ERRORES;
    private final Map<Class<?>, RegistradorBase<?>> registros = new HashMap();

    public RegistrosBase() {
        this.postRegistrarRegistradores();
        COMPONENTES = (RegistradorComponentesBase)this.getRegistrador(Componente.class);
        SONIDOS = (RegistradorSonidosBase)this.getRegistrador(SonidoBase.class);
        ACCIONES_ITEMS = (RegistradorAccionesItemsBase)this.getRegistrador(AccionItem.class);
        ACCIONES_BLOQUES = (RegistradorAccionesBloquesBase)this.getRegistrador(IAccionBloque.class);
        ACCIONES_ENTIDADES = (RegistradorAccionesEntidadesBase)this.getRegistrador(AccionEntidad.class);
        CREADOR_AREAS = (RegistradorCreadorAreasBase)this.getRegistrador(Area.class);
        CONDICIONES_GENERADORES = (RegistradorCondicionesGeneradorBase)this.getRegistrador(Condicion.class);
        TIPO_MARCADORES = (RegistradorTiposMarcadoresBase)this.getRegistrador(TipoMarcador.class);
        PATRONES = (RegistradorPatronBase)this.getRegistrador(Patron.class);
        DISPLAY_TRANSFORMACIONES = (RegistradorDisplayTransformacionesBase)this.getRegistrador(Display.class);
        ERRORES = (RegistradorErroresBase)this.getRegistrador(Exception.class);
    }

    protected <E, R extends RegistradorBase<?>> R getRegistrador(Class<E> clase) {
        RegistradorBase<?> registrador = this.registros.get(clase);
        return (R)((RegistradorBase)CastUtil.cast(registrador));
    }

    protected void registrarRegistradores() {
    }

    private void postRegistrarRegistradores() {
        this.registrarRegistradores();
        this.registrar(RegistradorSonidosBase::new);
        this.registrar(RegistradorAccionesItemsBase::new);
        this.registrar(RegistradorAccionesBloquesBase::new);
        this.registrar(RegistradorAccionesEntidadesBase::new);
        this.registrar(RegistradorCreadorAreasBase::new);
        this.registrar(RegistradorCondicionesGeneradorBase::new);
        this.registrar(RegistradorTiposMarcadoresBase::new);
        this.registrar(RegistradorPatronBase::new);
        this.registrar(RegistradorDisplayTransformacionesBase::new);
        this.registrar(RegistradorErroresBase::new);
    }

    protected Class<?> registrar(Supplier<RegistradorBase<?>> registradorSupplier) {
        RegistradorBase<?> registrador = registradorSupplier.get();
        Class<?> keyClass = registrador.getKeyClass();
        this.registros.putIfAbsent(keyClass, registrador);
        return keyClass;
    }
}

