/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa.generadores.generado;

import es.pyronixstudio.base.juego.mapa.generadores.generado.IGenerado;
import es.pyronixstudio.base.util.Ubicacion;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.lang.ref.WeakReference;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public abstract class GeneradoEntidadBase
implements IGenerado {
    protected WeakReference<Entity> weakEntity;
    protected final Location location;

    protected GeneradoEntidadBase(Ubicacion.BlockLocation location) {
        this.location = location.getMinecraftLocation().add(0.5, 0.0, 0.5);
    }

    @Override
    public void init() {
        this.weakEntity = new WeakReference<Entity>(this.generar());
        this.aplicarVectorY();
    }

    @Override
    public boolean sigueExistiendo() {
        Entity entity = (Entity)this.getEntity().get();
        if (entity == null) {
            return false;
        }
        return entity.isValid();
    }

    @Override
    public Location getLocation() {
        Entity entity = (Entity)this.getEntity().get();
        if (entity == null) {
            return null;
        }
        return entity.getLocation();
    }

    @Override
    public void reset() {
        this.getEntity().ifPresent(Entity::remove);
    }

    public UUID getUUID() {
        Entity entity = (Entity)this.getEntity().get();
        if (entity == null) {
            return null;
        }
        return entity.getUniqueId();
    }

    public Wrapper<Entity> getEntity() {
        return Wrapper.ofUnmodifiable((Object)((Entity)this.weakEntity.get()));
    }

    public String toString() {
        return this.weakEntity.toString();
    }

    protected abstract Entity generar();

    private void aplicarVectorY() {
        this.getEntity().ifPresent(entity -> {
            CastUtil.runIfInstance(LivingEntity.class, (Object)entity, viva -> {
                viva.setRemoveWhenFarAway(false);
                viva.setCanPickupItems(false);
            });
            entity.setPersistent(false);
            entity.setVelocity(new Vector(0.0, 0.3, 0.0));
        });
    }
}

