/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa.generadores.generado;

import es.pyronixstudio.base.juego.mapa.generadores.generado.IGenerado;
import es.pyronixstudio.base.util.Ubicacion;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.lang.ref.WeakReference;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class GeneradoBloque
implements IGenerado {
    public final Location location;
    public final Material material;
    public final WeakReference<Block> weakBlock;
    public final Material bloqueReset;

    public static GeneradoBloque of(Ubicacion.BlockLocation location, Material material, Material bloqueReset) {
        GeneradoBloque generadoBloque = new GeneradoBloque(location, material, bloqueReset);
        generadoBloque.init();
        return generadoBloque;
    }

    private GeneradoBloque(Ubicacion.BlockLocation location, Material material, Material bloqueReset) {
        this.location = location.getMinecraftLocation();
        this.weakBlock = new WeakReference<Block>(this.location.getBlock());
        this.material = material;
        this.bloqueReset = bloqueReset;
    }

    @Override
    public void init() {
        this.setMaterial(this.material);
    }

    private void setMaterial(Material material) {
        this.getBlock().ifPresent(block -> block.setType(material, false));
    }

    @Override
    public boolean sigueExistiendo() {
        return this.getType() == this.material;
    }

    private Material getType() {
        Block block = (Block)this.getBlock().get();
        if (block == null) {
            return null;
        }
        return block.getType();
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void reset() {
        this.setMaterial(this.bloqueReset);
    }

    public Wrapper<Block> getBlock() {
        return Wrapper.ofUnmodifiable((Object)((Block)this.weakBlock.get()));
    }

    public String toString() {
        return this.material.name();
    }
}

