/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa.generadores;

import es.pyronixstudio.base.juego.entidades.EntidadPersonalizadaBase;
import es.pyronixstudio.base.juego.entidades.EntityManager;
import es.pyronixstudio.base.juego.entidades.PropiedadesEntidadPersonalizadaBase;
import es.pyronixstudio.base.juego.mapa.MarcadorConfiguracion;
import es.pyronixstudio.base.juego.mapa.generadores.Generador;
import es.pyronixstudio.base.juego.mapa.generadores.generado.GeneradoEntidadPersonalizada;
import es.pyronixstudio.base.juego.mapa.generadores.generado.IGenerado;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.RandomUtil;
import es.pyronixstudio.util.colecciones.IndexedMap;
import es.pyronixstudio.util.ficheros.Valor;

public class GeneradorEntidad
extends Generador {
    private final IndexedMap<PropiedadesEntidadPersonalizadaBase, Integer> entidadesAGenerar;
    private final EntityManager<? extends EntidadPersonalizadaBase> entityManager;

    public GeneradorEntidad(MarcadorConfiguracion marcadorConfig, AbstractPartida<?, ?, ?> partida) {
        super(marcadorConfig, partida);
        IndexedMap crearMapa = null;
        this.entityManager = (EntityManager)CastUtil.cast((Object)((EntityManager)partida.componentSystem.get(RegistrosBase.COMPONENTES.ENTITY_MANAGER)));
        if (this.entityManager != null) {
            crearMapa = IndexedMap.of(this.getElementosAGenerar(), key -> (PropiedadesEntidadPersonalizadaBase)this.entityManager.getProps((String)key).get(), Valor::asInt);
        }
        this.entidadesAGenerar = crearMapa;
    }

    @Override
    protected IndexedMap<?, Integer> getFaltantes() {
        return this.entidadesAGenerar;
    }

    @Override
    protected void procesarPreTick() {
    }

    @Override
    protected void procesarTick() {
    }

    @Override
    protected IGenerado generar(Generador.UbicacionTickeable location) {
        IndexedMap.IndexedEntry parejaGenerar;
        if (this.entidadesAGenerar.isEmpty()) {
            return null;
        }
        IndexedMap.IndexedEntry indexedEntry = parejaGenerar = this.random ? RandomUtil.getRandomFromIndexedMap(this.entidadesAGenerar) : this.entidadesAGenerar.getFirst();
        if (parejaGenerar == null) {
            return null;
        }
        int porGenerar = (Integer)parejaGenerar.getValue();
        if (porGenerar == 0) {
            return null;
        }
        if (porGenerar != -1) {
            int nuevoMaximo;
            if ((nuevoMaximo = --porGenerar) == 0) {
                parejaGenerar.remove();
            } else {
                parejaGenerar.setValue((Object)nuevoMaximo);
            }
        }
        PropiedadesEntidadPersonalizadaBase aGenerar = (PropiedadesEntidadPersonalizadaBase)parejaGenerar.getKey();
        return GeneradoEntidadPersonalizada.of(location, aGenerar, this.entityManager, (Integer)this.partida.ID.get());
    }
}

