/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.equipo;

import es.pyronixstudio.base.core.exceptions.ExceptionManager;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.equipo.EnumColor;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.IManager;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class EquipoManager<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
implements IManager<EnumColor, E> {
    private Map<EnumColor, E> teams = new HashMap<EnumColor, E>();

    public final E addIfNotExists(EnumColor color, Function<EnumColor, E> teamFactory) {
        return (E)this.teams.computeIfAbsent(color, k -> (AbstractEquipo)teamFactory.apply(color));
    }

    @Override
    public void add(EnumColor color, E team) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Wrapper<E> get(EnumColor color) {
        return Wrapper.of((Object)((AbstractEquipo)this.teams.get((Object)color)));
    }

    @Override
    public final Wrapper<E> get(UUID playerUUID) {
        Wrapper wrapper = Wrapper.emptyUnmodifiable();
        List<AbstractEquipo> equipos = this.filter(e -> {
            Iterator iterator = e.jugadores.iterator();
            if (iterator.hasNext()) {
                AbstractJugador player = (AbstractJugador)iterator.next();
                return player.getMinecraftPlayer().getUniqueId().equals(playerUUID);
            }
            return false;
        });
        if (equipos.size() > 1) {
            Player player = Bukkit.getPlayer((UUID)playerUUID);
            if (player == null) {
                return Wrapper.empty();
            }
            String name = player.getName();
            ExceptionManager.throwSimpleException(RegistrosBase.ERRORES.PLAYER_IN_MORE_THAN_ONE_TEAM, Map.of("player", name));
        }
        if (!equipos.isEmpty()) {
            wrapper.set((Object)equipos.getFirst());
        }
        return wrapper;
    }

    public final Wrapper<J> getJugador(UUID playerUUID) {
        Wrapper jugador = Wrapper.emptyUnmodifiable();
        for (AbstractEquipo team : this.teams.values()) {
            for (AbstractJugador player : team.getJugadores()) {
                if (!player.getMinecraftPlayer().getUniqueId().equals(playerUUID)) continue;
                jugador.set((Object)player);
                break;
            }
            if (!jugador.isPresent()) continue;
            break;
        }
        return jugador;
    }

    @Override
    public Collection<E> getAll() {
        return this.teams.values();
    }

    @Override
    public Collection<EnumColor> getAllKeys() {
        return this.teams.keySet();
    }

    @Override
    public void remove(EnumColor color) {
        this.teams.remove((Object)color);
    }

    @Override
    public void removeAll() {
        this.teams.clear();
    }

    public final void changeAll(Map<EnumColor, E> teams) {
        this.teams = teams;
    }
}

