/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.entidades;

import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.juego.entidades.AccionEntidad;
import es.pyronixstudio.base.juego.items.ItemPersonalizado;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistradorNameSpaceBase;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.util.EntityUtil;
import es.pyronixstudio.base.util.PersistentDataContainerUtil;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.ficheros.Elemento;
import es.pyronixstudio.util.ficheros.Valor;
import es.pyronixstudio.util.wrapper.Wrapper;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Breedable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Steerable;
import org.bukkit.entity.Tameable;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.AbstractHorseInventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public class PropiedadesEntidadPersonalizadaBase {
    private String id;
    private EntityType entityType;
    private int health;
    private int damage;
    private Component name;
    private boolean showName;
    private float scale;
    private boolean tamed;
    private boolean baby;
    private boolean dropsInInv;
    private boolean disableEntityInteractions;
    private String[] drops;
    private final Elemento elemento;
    protected AccionEntidad<?, ?, ?, ?> accionEntidad;

    public PropiedadesEntidadPersonalizadaBase(Elemento entityElement) {
        this.elemento = entityElement;
    }

    protected final void cargarDatos() {
        this.cargarDatos(this.elemento);
    }

    protected final void cargarDatos(Elemento elemento) {
        this.id = elemento.id;
        elemento.runAndGetIfExist("type", valor -> {
            this.entityType = (EntityType)valor.asEnum(EntityType.class);
        });
        elemento.runAndGetIfExist("health", valor -> {
            this.health = valor.asInt();
        });
        elemento.runAndGetIfExist("damage", valor -> {
            this.damage = valor.asInt();
        });
        elemento.runAndGetIfExist("name", valor -> {
            this.name = PyronixPlugin.format(valor.asString(), false);
        });
        elemento.runAndGetIfExist("showName", valor -> {
            this.showName = valor.asBoolean();
        });
        elemento.runAndGetIfExist("scale", valor -> {
            this.scale = valor.asFloat();
        });
        elemento.runAndGetIfExist("drops", valor -> {
            this.drops = valor.asStringArray();
        });
        elemento.runAndGetIfExist("accion", valor -> {
            this.accionEntidad = (AccionEntidad)RegistrosBase.ACCIONES_ENTIDADES.get((Valor)valor).get();
        });
        elemento.runAndGetIfExist("tamed", valor -> {
            this.tamed = valor.asBoolean();
        });
        elemento.runAndGetIfExist("dropsInInv", valor -> {
            this.dropsInInv = valor.asBoolean();
        });
        elemento.runAndGetIfExist("baby", valor -> {
            this.baby = valor.asBoolean();
        });
        elemento.runAndGetIfExist("disableEntityInteractions", valor -> {
            this.disableEntityInteractions = valor.asBoolean();
        });
        if (this.accionEntidad != null) {
            this.accionEntidad.preInit(elemento.get("args").asUnmodifiableElemento());
        }
        this.cargarDatosExtras(elemento);
    }

    protected void cargarDatosExtras(Elemento entityElement) {
    }

    private void aplicarModificadoresAntesDelSpawn(Entity entity) {
        PersistentDataContainerUtil.setDataToHolder((PersistentDataHolder)entity, RegistradorNameSpaceBase.ENTIDAD_PERSONALIZADA, PersistentDataType.STRING, this.id);
        entity.setCustomNameVisible(this.showName);
        entity.customName(this.name);
        CastUtil.runIfInstance(LivingEntity.class, (Object)entity, livingEntity -> {
            EntityUtil.setAttribute(livingEntity, Attribute.MAX_HEALTH, this.health);
            livingEntity.setHealth((double)this.health);
            EntityUtil.setAttribute(livingEntity, Attribute.ATTACK_DAMAGE, this.damage);
            EntityUtil.setAttribute(livingEntity, Attribute.SCALE, this.scale);
        });
        CastUtil.runIfInstance(Ageable.class, (Object)entity, ageable -> {
            if (this.baby) {
                ageable.setBaby();
            } else {
                ageable.setAdult();
            }
        });
        CastUtil.runIfInstance(Breedable.class, (Object)entity, breedable -> breedable.setAgeLock(true));
        CastUtil.runIfInstance(Tameable.class, (Object)entity, tameable -> tameable.setTamed(this.tamed));
        CastUtil.runIfInstance(InventoryHolder.class, (Object)entity, inventoryHolder -> CastUtil.runIfInstance(AbstractHorseInventory.class, (Object)inventoryHolder.getInventory(), horseInventory -> horseInventory.setSaddle(ItemStack.of((Material)Material.SADDLE))));
        CastUtil.runIfInstance(Steerable.class, (Object)entity, steerable -> steerable.setSaddle(true));
        this.aplicarModificadoresExtras(entity);
    }

    protected void aplicarModificadoresExtras(Entity entity) {
    }

    public Entity spawn(Location location) {
        World world = location.getWorld();
        return world.spawnEntity(location, this.entityType, CreatureSpawnEvent.SpawnReason.CUSTOM, this::aplicarModificadoresAntesDelSpawn);
    }

    public Elemento getElemento() {
        return this.elemento;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public int getHealth() {
        return this.health;
    }

    public int getDamage() {
        return this.damage;
    }

    public Component getName() {
        return this.name;
    }

    public boolean isShowName() {
        return this.showName;
    }

    public float getScale() {
        return this.scale;
    }

    public String[] getDrops() {
        return this.drops;
    }

    public boolean isDisableEntityInteractions() {
        return this.disableEntityInteractions;
    }

    public void drop(AbstractJugador<?, ?, ?> player) {
        for (String itemId : this.drops) {
            Wrapper<ItemPersonalizado> itemPersonalizadoWrapper = player.getItem(itemId);
            ItemPersonalizado item = (ItemPersonalizado)itemPersonalizadoWrapper.get();
            if (!player.itemCanEnterInv(item)) continue;
            player.giveItem(itemId, 1);
        }
    }
}

