/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.entidades;

import es.pyronixstudio.base.core.RutasBase;
import es.pyronixstudio.base.core.exceptions.ExceptionManager;
import es.pyronixstudio.base.juego.entidades.EntidadPersonalizadaBase;
import es.pyronixstudio.base.juego.entidades.PropiedadesEntidadPersonalizadaBase;
import es.pyronixstudio.base.juego.mapa.AbstractMapa;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.IManager;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.util.ficheros.Elemento;
import es.pyronixstudio.util.ficheros.PyronixFile;
import es.pyronixstudio.util.ficheros.Valor;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;

public class EntityManager<E extends EntidadPersonalizadaBase>
implements IManager<UUID, E>,
IReseteable {
    private final Map<UUID, E> entities = new HashMap<UUID, E>();
    public final Set<UUID> basuraGeneradaPorEntidad = new HashSet<UUID>();
    private final Map<String, PropiedadesEntidadPersonalizadaBase> registerEntities = new HashMap<String, PropiedadesEntidadPersonalizadaBase>();
    private final BiFunction<Entity, PropiedadesEntidadPersonalizadaBase, E> entityFactory;
    private final Function<Elemento, PropiedadesEntidadPersonalizadaBase> propsFactory;
    private final AbstractPartida<?, ?, ?> partida;

    public EntityManager(AbstractPartida<?, ?, ?> partida, Function<Elemento, PropiedadesEntidadPersonalizadaBase> propsFactory, BiFunction<Entity, PropiedadesEntidadPersonalizadaBase, E> entityFactory) {
        this.entityFactory = entityFactory;
        this.propsFactory = propsFactory;
        this.partida = partida;
        this.registerEntities();
    }

    private void registerEntities() {
        PyronixFile mapFile;
        ArrayList<PyronixFile> ficheros = new ArrayList<PyronixFile>();
        ficheros.add(RutasBase.ENTITIES_FICHERO);
        AbstractMapa mapa = (AbstractMapa)this.partida.componentSystem.get(RegistrosBase.COMPONENTES.MAPA);
        if (mapa != null && (mapFile = RutasBase.ENTITIES_FICHERO_MAPA.apply(mapa.nombreUnico)).existe()) {
            ficheros.add(mapFile);
        }
        LinkedList<Map.Entry<Elemento, String>> childs = new LinkedList<Map.Entry<Elemento, String>>();
        for (PyronixFile file : ficheros) {
            file.parsear();
            List ids = file.getIds();
            for (String id : ids) {
                Elemento elemento = file.getElemento(id);
                Valor parent = elemento.get("parent");
                if (parent != null) {
                    childs.add(Map.entry(elemento, parent.asString()));
                    continue;
                }
                PropiedadesEntidadPersonalizadaBase props = this.propsFactory.apply(elemento);
                props.cargarDatos();
                this.registerEntities.put(id, props);
            }
        }
        while (!childs.isEmpty()) {
            Map.Entry childEntry = (Map.Entry)childs.poll();
            Elemento child = (Elemento)childEntry.getKey();
            String parentId = (String)childEntry.getValue();
            Elemento parent = this.registerEntities.get(parentId).getElemento();
            if (parent == null) {
                ExceptionManager.throwSimpleException(RegistrosBase.ERRORES.ENTITY_PARENT_NOT_FOUND, Map.of("id", child.id, "parent", parentId));
            }
            PropiedadesEntidadPersonalizadaBase props = this.propsFactory.apply(child);
            props.cargarDatos(parent);
            props.cargarDatos();
            this.registerEntities.put(child.id, props);
        }
    }

    public Wrapper<PropiedadesEntidadPersonalizadaBase> getProps(String id) {
        return Wrapper.of((Object)this.registerEntities.get(id));
    }

    public void createEntityCustom(Entity entity, PropiedadesEntidadPersonalizadaBase props) {
        this.add(entity.getUniqueId(), (E)((EntidadPersonalizadaBase)this.entityFactory.apply(entity, props)));
    }

    @Override
    public void add(UUID uuid, E customEntity) {
        this.entities.computeIfAbsent(uuid, k -> customEntity);
    }

    @Override
    public final Wrapper<E> get(Entity minecraftEntity) {
        if (minecraftEntity == null) {
            return Wrapper.empty();
        }
        return this.get(minecraftEntity.getUniqueId());
    }

    @Override
    public Wrapper<E> get(UUID uuid) {
        return Wrapper.of((Object)((EntidadPersonalizadaBase)this.entities.get(uuid)));
    }

    @Override
    public Collection<E> getAll() {
        return this.entities.values();
    }

    @Override
    public Collection<UUID> getAllKeys() {
        return this.entities.keySet();
    }

    @Override
    public void remove(UUID uuid) {
        this.entities.remove(uuid);
    }

    @Override
    public void removeAll() {
        this.entities.clear();
        this.basuraGeneradaPorEntidad.clear();
    }

    @Override
    public boolean reset(AbstractPartida<?, ?, ?> partida) {
        this.registerEntities.clear();
        this.entities.clear();
        this.basuraGeneradaPorEntidad.forEach((? super T uuid) -> {
            Entity entity = Bukkit.getEntity((UUID)uuid);
            if (entity != null && entity.isValid()) {
                entity.remove();
            }
        });
        this.basuraGeneradaPorEntidad.clear();
        return false;
    }
}

