/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.util;

import es.pyronixstudio.base.juego.items.contextos.ItemUseContext;
import es.pyronixstudio.base.registros.RegistradorNameSpaceBase;
import es.pyronixstudio.base.util.ItemStackUtil;
import es.pyronixstudio.util.EnumUtil;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.projectiles.ProjectileSource;

public class EntityUtil {
    public static void setAttribute(LivingEntity livingEntity, Attribute keyAttribute, double value) {
        AttributeInstance attribute = livingEntity.getAttribute(keyAttribute);
        if (attribute != null) {
            attribute.setBaseValue(value);
        }
    }

    public static ItemUseContext.EnumUseType getEntityUseType(ItemStack projectileStack) {
        if (projectileStack == null) {
            return null;
        }
        String useType = (String)ItemStackUtil.getDataFromItemStack(projectileStack, RegistradorNameSpaceBase.ITEM_USE_TYPE, PersistentDataType.STRING);
        return (ItemUseContext.EnumUseType)((Object)EnumUtil.valueOfSecure(ItemUseContext.EnumUseType.class, (String)useType));
    }

    public static Entity getShooter(Entity projectileEntity) {
        if (projectileEntity instanceof Projectile) {
            Projectile projectile = (Projectile)projectileEntity;
            ProjectileSource shooter = projectile.getShooter();
            if (shooter == null) {
                return null;
            }
            return (Entity)shooter;
        }
        return null;
    }

    public static <T extends Entity> T getTargetedEntity(Player player, int maxDistance, boolean ignoreBlocks, Class<T> castClass) {
        Entity encontrado = player.getTargetEntity(maxDistance, ignoreBlocks);
        Entity resultado = encontrado != null && castClass.isInstance(encontrado) ? (Entity)castClass.cast(encontrado) : null;
        return (T)resultado;
    }
}

