/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.partida.jugador;

import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.core.PyronixScheduler;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.items.ItemManager;
import es.pyronixstudio.base.juego.items.ItemPersonalizado;
import es.pyronixstudio.base.juego.mapa.AbstractMapa;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.sonido.SonidoManager;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public abstract class AbstractJugador<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
implements IReseteable {
    public static final int SLOTS_HOTBAR = 9;
    public static final int SLOTS_INVENTARIO = 36;
    public static int SLOTS_MAXIMOS_COMPROBAR = 36;
    public static final int MAX_HUNGER_AND_SATURARION = 20;
    public static final float WALK_SPEED = 0.2f;
    protected Player player;
    protected E equipo;
    protected boolean marcadoParaBorrarInv;
    protected boolean penalizado;
    private List<PyronixScheduler.PyronixTask> tareas;
    private final Map<String, ItemPersonalizado> inventarioItems = new HashMap<String, ItemPersonalizado>();
    private int slotsEnUso = 0;
    private boolean ignoreLeftInteracion = false;

    public AbstractJugador(Player player, E equipo, boolean anunciar) {
        this.player = player;
        this.equipo = equipo;
        if (anunciar) {
            player.sendMessage(PyronixPlugin.format(String.format("<gold>Estas en el equipo %s", ((AbstractEquipo)equipo).getColor().formatedColoredName())));
            SonidoManager.reproducirSonidoAJugador(player, RegistrosBase.SONIDOS.GENERAR_EQUIPOS, 1.0f, 1.0f);
        }
        this.setPropiedadesBasicasComienzo();
    }

    public final void actualizarInv(ItemManager<J, E, P> itemManager) {
        HashSet<String> porActualizar = new HashSet<String>(this.inventarioItems.keySet());
        if (!this.esMinecraftPlayerValido()) {
            return;
        }
        porActualizar.forEach(id -> this.inventarioItems.get(id).setCantidad(0));
        PlayerInventory inv = this.player.getInventory();
        int slotsUsados = 0;
        for (int i = 0; i < SLOTS_MAXIMOS_COMPROBAR; ++i) {
            String idItem;
            ItemStack item = inv.getItem(i);
            if (item == null || (idItem = (String)itemManager.getItemIdFromNBT(item).getOrDefault(null)) == null) continue;
            ++slotsUsados;
            ItemPersonalizado aMeter = (ItemPersonalizado)itemManager.getItem(idItem).getOrDefault(null);
            if (aMeter == null) continue;
            ItemPersonalizado actualizar = this.inventarioItems.computeIfAbsent(idItem, k -> aMeter.clone());
            actualizar.sumarCantidad(item.getAmount());
        }
        this.slotsEnUso = slotsUsados;
    }

    public void giveItem(String itemID, int cantidad) {
        Object partida = ((AbstractEquipo)this.equipo).partida;
        AbstractMapa mapa = (AbstractMapa)((AbstractPartida)partida).componentSystem.get(RegistrosBase.COMPONENTES.MAPA);
        if (mapa == null) {
            return;
        }
        ItemManager itemManager = mapa.getItemManager();
        itemManager.darItemInsecure(itemID, this, cantidad);
    }

    public boolean isInvLleno() {
        return this.slotsEnUso >= SLOTS_MAXIMOS_COMPROBAR;
    }

    public boolean itemCanEnterInv(ItemPersonalizado item) {
        if (item == null) {
            return true;
        }
        boolean maxSlotsUsed = this.isInvLleno();
        int cantidad = item.getCantidad();
        if (cantidad == 0 && maxSlotsUsed) {
            return false;
        }
        return cantidad < item.maxStack;
    }

    public Wrapper<ItemPersonalizado> getItem(String idItem) {
        return Wrapper.ofUnmodifiable((Object)this.inventarioItems.get(idItem));
    }

    protected void setPropiedadesBasicasComienzo() {
        this.player.setGameMode(GameMode.SURVIVAL);
        this.player.setLevel(0);
        this.player.setExp(0.0f);
        this.player.setHealth(this.player.getAttribute(Attribute.MAX_HEALTH).getDefaultValue());
        this.player.setSaturation(20.0f);
        this.player.setFoodLevel(20);
        this.player.setWalkSpeed(0.2f);
        this.setearPropiedadesComienzo();
    }

    protected abstract void setearPropiedadesComienzo();

    public E getEquipo() {
        return this.equipo;
    }

    public void setEquipo(E equipo) {
        this.equipo = equipo;
    }

    public void borrarEfectos() {
        if (!this.esMinecraftPlayerValido()) {
            return;
        }
        for (PotionEffect efecto : this.player.getActivePotionEffects()) {
            this.player.removePotionEffect(efecto.getType());
        }
    }

    public void vaciarTodosLosSlots() {
        if (!this.esMinecraftPlayerValido()) {
            return;
        }
        PlayerInventory inventario = this.player.getInventory();
        inventario.clear();
        inventario.setItemInOffHand(new ItemStack(Material.AIR));
    }

    public void vaciarTodoMenosArmadura() {
        this.vaciarInvSlots(36, true);
    }

    public void vaciarHotBarCompleta() {
        this.vaciarInvSlots(9, true);
    }

    private void vaciarInvSlots(int cantidad, boolean manoIzquierda) {
        if (!this.esMinecraftPlayerValido()) {
            return;
        }
        PlayerInventory inventario = this.player.getInventory();
        ItemStack aPoner = new ItemStack(Material.AIR);
        for (int i = 0; i < cantidad; ++i) {
            inventario.setItem(i, aPoner);
        }
        inventario.setItemInOffHand(aPoner);
    }

    public boolean esMinecraftPlayerValido() {
        return this.player != null && this.player.isConnected();
    }

    public void actualizarInstancia(Player player) {
        this.player = player;
    }

    public Player getMinecraftPlayer() {
        return this.player;
    }

    public void alDesmarcarParaBorrar() {
    }

    public void marcarParaBorrar(boolean activar) {
        if (this.marcadoParaBorrarInv) {
            this.alDesmarcarParaBorrar();
        }
        this.marcadoParaBorrarInv = activar;
    }

    public boolean estaPenalizado() {
        return this.penalizado;
    }

    public void onRespawn() {
        if (this.tareas != null) {
            this.tareas.forEach(tarea -> {
                if (!tarea.isCancelled()) {
                    tarea.cancel();
                }
            });
            this.tareas.clear();
        }
        this.inventarioItems.clear();
    }

    public void agregarTarea(PyronixScheduler.PyronixTask tarea) {
        if (this.tareas == null) {
            this.tareas = new ArrayList<PyronixScheduler.PyronixTask>();
        }
        this.tareas.add(tarea);
    }

    public void damage(float puntos, J aplicador) {
        this.getMinecraftPlayer().damage((double)puntos, (Entity)((AbstractJugador)aplicador).player);
    }

    public void alMorir(Wrapper<J> killer, Location ubicacionMuerte) {
    }

    public void penalizar(int ticks, Wrapper<Component> mensajeOpcional) {
        this.penalizado = true;
        this.setInvulnerable(true);
        PyronixScheduler.runTaskLater(ticks, task -> {
            this.penalizado = false;
            this.setInvulnerable(false);
            mensajeOpcional.ifPresent(arg_0 -> ((Player)this.player).sendMessage(arg_0));
        });
    }

    public void setCongelar(boolean congelar) {
        if (!this.esMinecraftPlayerValido()) {
            return;
        }
        if (congelar) {
            this.player.setWalkSpeed(0.0f);
            this.player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP_BOOST, 9999999, 150));
        } else {
            this.player.setWalkSpeed(0.2f);
            this.player.removePotionEffect(PotionEffectType.JUMP_BOOST);
        }
    }

    public void setCongelar(int ticks) {
        this.setCongelar(true);
        PyronixScheduler.runTaskLater(ticks, task -> this.setCongelar(false));
    }

    public void setInvulnerable(boolean invulnerable) {
        if (this.esMinecraftPlayerValido()) {
            this.player.setInvulnerable(invulnerable);
        }
    }

    public void setInvisible(boolean invisible) {
        if (invisible) {
            ((AbstractPartida)((AbstractEquipo)this.equipo).partida).jugadorManager.forEach(jugador -> jugador.getMinecraftPlayer().hidePlayer(PyronixPlugin.INSTANCE, this.player));
        } else {
            this.quitarHidePlayers();
        }
    }

    private void quitarHidePlayers() {
        ((AbstractPartida)((AbstractEquipo)this.equipo).partida).jugadorManager.forEach(jugador -> jugador.getMinecraftPlayer().showPlayer(PyronixPlugin.INSTANCE, this.player));
    }

    public void setIgnoreLeftInteraction(boolean ignoreLeftInteracion) {
        this.ignoreLeftInteracion = ignoreLeftInteracion;
    }

    public boolean hasIgnoreLeftInteraction() {
        return this.ignoreLeftInteracion;
    }

    @Override
    public boolean reset(AbstractPartida<?, ?, ?> partida) {
        if (this.esMinecraftPlayerValido()) {
            this.borrarEfectos();
            this.quitarHidePlayers();
        }
        this.resetExtra();
        return false;
    }

    protected abstract void resetExtra();

    public String toString() {
        return String.format("AbstractJugador=[Nombre:%s, EsValido:%s]", this.player.getName(), this.esMinecraftPlayerValido());
    }
}

