/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.partida;

import es.pyronixstudio.base.comandos.Argumentos;
import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.mapa.AbstractMapa;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.EnumEstadoPartida;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;
import org.bukkit.entity.Player;

public final class PartidaManager<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>> {
    private final Map<Integer, P> partidas = new ConcurrentHashMap<Integer, P>();
    private final Queue<Integer> idsAReusar = new ConcurrentLinkedDeque<Integer>();
    private final Supplier<P> partidaSupplier;
    private final boolean multiPartida;
    private final PyronixPlugin<J, E, P> plugin;

    public PartidaManager(PyronixPlugin<J, E, P> plugin, boolean multiPartida) {
        this.plugin = plugin;
        this.partidaSupplier = plugin.getPartidaSupplier();
        this.multiPartida = multiPartida;
    }

    public boolean isMultiPartida() {
        return this.multiPartida;
    }

    public Collection<Integer> getIdsEnUso() {
        return this.partidas.keySet();
    }

    public Collection<Integer> getIdsLibres() {
        return this.idsAReusar;
    }

    public Wrapper<J> getJugador(UUID uuid) {
        return this.filtrar(uuid);
    }

    public Wrapper<J> getJugador(Player player) {
        if (player == null || !player.isConnected()) {
            return Wrapper.empty();
        }
        return this.getJugador(player.getUniqueId());
    }

    public Wrapper<J> searchPlayerInTeams(Player player) {
        for (AbstractPartida partida : this.partidas.values()) {
            Wrapper wrapper = partida.equipoManager.getJugador(player.getUniqueId());
            if (!wrapper.isPresent()) continue;
            return wrapper;
        }
        return Wrapper.emptyUnmodifiable();
    }

    public Wrapper<P> get(Wrapper<Integer> idOptional) {
        return this.get(this.parseID(idOptional));
    }

    private Wrapper<P> get(int id) {
        return Wrapper.of((Object)((AbstractPartida)this.partidas.get(id)));
    }

    public Wrapper<P> get(Player player) {
        if (player == null) {
            return Wrapper.empty();
        }
        return this.get(player.getUniqueId());
    }

    public Wrapper<P> get(UUID uuid) {
        AbstractJugador jugador = (AbstractJugador)this.getJugador(uuid).get();
        if (jugador != null) {
            return Wrapper.of(((AbstractEquipo)jugador.getEquipo()).partida);
        }
        return Wrapper.empty();
    }

    public boolean mapaEnPartida(AbstractMapa<?, J, E, P> mapa) {
        return this.mapaEnPartida((Object)mapa);
    }

    public boolean mapaEnPartida(String id) {
        return this.mapaEnPartida((Object)id);
    }

    private boolean mapaEnPartida(Object otroMapa) {
        if (otroMapa == null) {
            return false;
        }
        for (AbstractPartida partida : this.partidas.values()) {
            AbstractMapa partidaMapa = (AbstractMapa)partida.componentSystem.get(RegistrosBase.COMPONENTES.MAPA);
            if (partidaMapa == null || !partidaMapa.equals(otroMapa)) continue;
            return true;
        }
        return false;
    }

    private int parseID(Wrapper<Integer> idOptional) {
        return (Integer)idOptional.getOrDefault((Object)0);
    }

    public boolean remove(Wrapper<Integer> id) {
        int idParsed = this.parseID(id);
        Wrapper<P> partidaOptional = this.get(idParsed);
        if (partidaOptional.isPresent()) {
            AbstractPartida partida = (AbstractPartida)partidaOptional.get();
            this.partidas.remove(idParsed);
            partida.resetCompleto();
            this.idsAReusar.add(idParsed);
        }
        return partidaOptional.isPresent();
    }

    public void crear(int id, Argumentos argumentos) {
        this.crear((Wrapper<Integer>)Wrapper.of((Object)id), argumentos);
    }

    public void crear(Wrapper<Integer> id, Argumentos argumentos) {
        argumentos.enviarMensaje("<green>Creando partida, espere...");
        int idAUsar = (Integer)id.get();
        P partida = this.crearOReutilizar(id);
        if (((AbstractPartida)partida).getEstado().haSuperadoOEstaEnEstado(EnumEstadoPartida.CREADA)) {
            argumentos.addErrorMensaje("Error -> Hay una partida creada, use /reset <ID> antes");
            return;
        }
        EnumEstadoPartida estadoAnterior = ((AbstractPartida)partida).getEstado();
        ((AbstractPartida)partida).setEstado(EnumEstadoPartida.CREADA);
        ((AbstractPartida)partida).crear(argumentos);
        if (argumentos.asError()) {
            ((AbstractPartida)partida).reset();
            return;
        }
        if (estadoAnterior.haSuperadoOEstaEnEstado(EnumEstadoPartida.INICIALIZADA)) {
            ((AbstractPartida)partida).volverAPreinicializarEquiposYJugadores();
        }
        argumentos.addMensaje(String.format("<green>Se creo la partida con el ID:<gold> %s<green> con exito!", idAUsar));
    }

    private P crearOReutilizar(Wrapper<Integer> id) {
        int idAUsar = this.crearOReusarID(id);
        boolean yaExistia = this.partidas.containsKey(idAUsar);
        AbstractPartida partida = this.partidas.getOrDefault(idAUsar, (AbstractPartida)this.partidaSupplier.get());
        if (!yaExistia) {
            PyronixPlugin.registrarEventos(partida);
            partida.ID.set((Object)idAUsar);
            partida.setPlugin(this.plugin);
            this.partidas.put(idAUsar, partida);
        }
        return (P)partida;
    }

    public void preInicializar(Wrapper<Integer> id, Argumentos argumentos) {
        P partida = this.crearOReutilizar(id);
        if (((AbstractPartida)partida).getEstado().haSuperadoOEstaEnEstado(EnumEstadoPartida.PRE_INICIALIZADA)) {
            argumentos.addErrorMensaje("Error -> Hay una partida pre inicializada, use /reset <ID> antes");
            return;
        }
        ((AbstractPartida)partida).setEstado(EnumEstadoPartida.PRE_INICIALIZADA);
        argumentos.addMensaje(String.format("<green>Se preinicializo la partida con el ID:<gold> %s<green> con exito!", id.get()));
    }

    private int crearOReusarID(Wrapper<Integer> preferencia) {
        if (!this.multiPartida) {
            return 0;
        }
        int id = -1;
        if (preferencia.isPresent()) {
            id = (Integer)preferencia.get();
        }
        if (id == -1) {
            id = this.idsAReusar.isEmpty() ? this.partidas.size() : this.idsAReusar.poll().intValue();
        }
        return id;
    }

    private Wrapper<J> filtrar(UUID uuid) {
        for (AbstractPartida partida : this.partidas.values()) {
            Wrapper jugador = partida.jugadorManager.get(uuid);
            if (!jugador.isPresent()) continue;
            return jugador;
        }
        return Wrapper.empty();
    }
}

