/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.partida;

import es.pyronixstudio.base.core.PyronixScheduler;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;

public abstract class AbstractTiempoManager<P extends AbstractPartida<?, ?, ?>>
implements IReseteable {
    protected P partida;
    protected PyronixScheduler.PyronixTask tareaCronometro;
    protected boolean tickear = true;
    protected int tiempoActual = 0;
    private final int suma;

    protected AbstractTiempoManager(P partida, int empezarEn, boolean inverso) {
        this.partida = partida;
        this.suma = inverso ? -1 : 1;
        this.tiempoActual = empezarEn;
    }

    public final void partidaIniciada() {
        this.tareaCronometro = PyronixScheduler.runTaskTimer(0L, 20L, task -> {
            if (task.isCancelled()) {
                return;
            }
            this.mostrarTimer(this.tiempoActual);
            this.preTickCronometro();
            if (this.tickear) {
                this.tickCronometro();
                this.tiempoActual += this.suma;
            }
        });
    }

    protected abstract void preTickCronometro();

    protected abstract void tickCronometro();

    public void finalizarPartida() {
        if (this.tareaCronometro != null) {
            this.tareaCronometro.cancel();
        }
        ((AbstractPartida)this.partida).terminar();
    }

    @Override
    public boolean reset(AbstractPartida<?, ?, ?> partida) {
        if (this.tareaCronometro != null) {
            this.tareaCronometro.cancel();
            this.tareaCronometro = null;
        }
        this.tiempoActual = 0;
        return false;
    }

    private void mostrarTimer(int segundosTotales) {
        StringBuilder builder = new StringBuilder();
        int horas = segundosTotales / 3600;
        int minutos = segundosTotales % 3600 / 60;
        int segundos = segundosTotales % 60;
        if (horas != 0) {
            builder.append(this.getFormatInt(horas));
            builder.append(":");
        }
        builder.append(this.getFormatInt(minutos));
        builder.append(":");
        builder.append(this.getFormatInt(segundos));
        TextComponent temporizador = Component.text((String)builder.toString());
        ((AbstractPartida)this.partida).jugadorManager.forEach(arg_0 -> AbstractTiempoManager.lambda$mostrarTimer$1((Component)temporizador, arg_0));
    }

    private String getFormatInt(int number) {
        Object numberString = Integer.toString(number);
        if (number < 10) {
            numberString = "0" + (String)numberString;
        }
        return numberString;
    }

    public int getTiempoActual() {
        return this.tiempoActual;
    }

    private static /* synthetic */ void lambda$mostrarTimer$1(Component temporizador, AbstractJugador jugador) {
        if (jugador.esMinecraftPlayerValido()) {
            jugador.getMinecraftPlayer().sendActionBar(temporizador);
        }
    }
}

