/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa;

import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.core.RutasBase;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.items.ItemManager;
import es.pyronixstudio.base.juego.mapa.AbstractConfiguracionMapa;
import es.pyronixstudio.base.juego.mapa.MarcadorConfiguracion;
import es.pyronixstudio.base.juego.mapa.generadores.GeneradoresManager;
import es.pyronixstudio.base.juego.mapa.serializador.Marcadores;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.util.Logger;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;

public abstract class AbstractMapa<C extends AbstractConfiguracionMapa, J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
implements IReseteable {
    protected final Path carpeta;
    protected final C configMapa;
    protected final P partida;
    public final Marcadores marcadores;
    public final GeneradoresManager generadoresManager;
    private ItemManager<J, E, P> itemManager;
    public final String nombreUnico;

    public static boolean existeMapa(String nombre) {
        return RutasBase.MAPA_CARPETA.apply(nombre).toFile().exists();
    }

    public AbstractMapa(P partida, String nombreMapa, Function<String, C> creadorConfiguracion) {
        this.partida = partida;
        this.carpeta = RutasBase.MAPA_CARPETA.apply(nombreMapa);
        this.configMapa = (AbstractConfiguracionMapa)creadorConfiguracion.apply(nombreMapa);
        this.generadoresManager = ((AbstractPartida)partida).resetManager.agregarFunction(GeneradoresManager::new);
        this.marcadores = ((AbstractConfiguracionMapa)this.configMapa).obtenerMarcadoresPorTipo();
        this.marcadores.setPartida((AbstractPartida<?, ?, ?>)partida);
        this.nombreUnico = nombreMapa;
    }

    public void asignarSpawn() {
        List<MarcadorConfiguracion> marcadoresSpawns = this.marcadores.get(RegistrosBase.TIPO_MARCADORES.SPAWN_EQUIPO);
        ArrayDeque colaUbicaciones = new ArrayDeque();
        this.marcadores.ejecutarEnTipo(RegistrosBase.TIPO_MARCADORES.SPAWN_EQUIPO, spawnMarcador -> marcadoresSpawns.forEach(marcadorSpawn -> colaUbicaciones.addAll(marcadorSpawn.ubicaciones))).ifExito(() -> ((AbstractPartida)this.partida).equipoManager.forEach(equipo -> equipo.componentSystem.add(RegistrosBase.COMPONENTES.SPAWN, (Location)colaUbicaciones.poll()))).ifFracaso(() -> Logger.severe((String)"Se llamo a la funcion #asignarSpawn pero no hay ninguna configuracion con ese tipo de marcador", (Object[])new Object[0]));
    }

    public void configurarGeneradores() {
        this.marcadores.ejecutarEnTipo(RegistrosBase.TIPO_MARCADORES.GENERADOR, this.generadoresManager::add).ifFracaso(() -> Logger.info((String)"No hay marcadores del tipo generador", (Object[])new Object[0]));
    }

    public void setItemManager(ItemManager<J, E, P> itemManager) {
        if (itemManager == null) {
            return;
        }
        this.itemManager = itemManager;
    }

    public ItemManager<J, E, P> getItemManager() {
        return this.itemManager;
    }

    public void partidaIniciada() {
        this.generadoresManager.partidaIniciada();
    }

    public int hashCode() {
        return this.nombreUnico.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof String) {
            String id = (String)obj;
            return this.nombreUnico.equals(id);
        }
        if (obj instanceof AbstractMapa) {
            AbstractMapa otroMapa = (AbstractMapa)obj;
            return otroMapa.nombreUnico.equals(this.nombreUnico);
        }
        return false;
    }

    public void resetMapa() {
        if (((AbstractConfiguracionMapa)this.configMapa).isReseteable()) {
            ((AbstractConfiguracionMapa)this.configMapa).reset();
        }
        this.generadoresManager.reset((AbstractPartida<?, ?, ?>)this.partida);
    }

    public final List<Component> comprobar() {
        ArrayList<Component> erroresEspecifico = new ArrayList<Component>();
        this.comprobarExtra(erroresEspecifico);
        if (((AbstractConfiguracionMapa)this.configMapa).isModoEditorEnabled()) {
            erroresEspecifico.add(PyronixPlugin.format("<red>Modo editor Activado."));
        }
        if (((AbstractPartida)this.partida).plugin.partidaManager.mapaEnPartida(this)) {
            erroresEspecifico.add(PyronixPlugin.format("<red>Mapa en uso en otra partida."));
        }
        ArrayList<Component> erroresCompletos = new ArrayList<Component>();
        if (erroresEspecifico.isEmpty()) {
            return List.of();
        }
        erroresCompletos.add(PyronixPlugin.format("<red>Mapa con errores:"));
        erroresCompletos.addAll(erroresEspecifico);
        return erroresCompletos;
    }

    protected abstract void comprobarExtra(List<Component> var1);
}

