/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.estructuras;

import es.pyronixstudio.base.estructuras.EstructuraGenerada;
import es.pyronixstudio.base.estructuras.Patron;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.registros.tipo.IRegistro;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class EstructuraManager
implements IReseteable {
    private Map<IRegistro<Patron>, Patron> cache = new HashMap<IRegistro<Patron>, Patron>();

    public EstructuraGenerada generar(IRegistro<Patron> registro, Location ubicacion, BlockFace orientacion, Set<Material> materilesPermitidos, boolean force) {
        Patron patron = this.buscarOMeterCache(registro);
        EstructuraGenerada generada = EstructuraGenerada.create();
        patron.ejecutarEnCadaBloque(ubicacion, orientacion, (block, material) -> {
            boolean tipoValido;
            Material tipo = block.getType();
            boolean bl = force ? false : (tipoValido = tipo != Material.AIR);
            if (tipoValido && (materilesPermitidos == null || !materilesPermitidos.contains(tipo))) {
                return;
            }
            generada.add((Block)block);
            block.setType(material);
        });
        return generada;
    }

    public EstructuraGenerada generar(IRegistro<Patron> supplier, Location ubicacion, BlockFace orientacion, Set<Material> materilesPermitidos) {
        return this.generar(supplier, ubicacion, orientacion, materilesPermitidos, false);
    }

    public EstructuraGenerada generar(IRegistro<Patron> supplier, Location ubicacion, Set<Material> materilesPermitidos, boolean force) {
        return this.generar(supplier, ubicacion, BlockFace.NORTH, materilesPermitidos, force);
    }

    public EstructuraGenerada generar(IRegistro<Patron> supplier, Location ubicacion) {
        return this.generar(supplier, ubicacion, null, false);
    }

    public Patron buscarOMeterCache(IRegistro<Patron> registro) {
        if (registro.isEmpty()) {
            return null;
        }
        return this.cache.computeIfAbsent(registro, key -> {
            Patron patron = (Patron)registro.crear();
            patron.parsear();
            return patron;
        });
    }

    @Override
    public boolean reset(AbstractPartida<?, ?, ?> partida) {
        this.cache.clear();
        return false;
    }
}

