/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa.generadores.generado;

import es.pyronixstudio.base.juego.mapa.generadores.generado.IGenerado;
import es.pyronixstudio.base.util.Ubicacion;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public abstract class GeneradoEntidadBase
implements IGenerado {
    protected Entity entity;
    protected final Location location;

    protected GeneradoEntidadBase(Ubicacion.BlockLocation location) {
        this.location = location.getMinecraftLocation().add(0.5, 0.0, 0.5);
    }

    @Override
    public void init() {
        this.entity = this.generar();
        this.aplicarVectorY();
    }

    @Override
    public boolean sigueExistiendo() {
        return this.entity.isValid();
    }

    @Override
    public Location getLocation() {
        return this.entity.getLocation();
    }

    @Override
    public void reset() {
        this.entity.remove();
    }

    public UUID getUUID() {
        return this.entity.getUniqueId();
    }

    public String toString() {
        return this.entity.toString();
    }

    protected abstract Entity generar();

    private void aplicarVectorY() {
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity viva = (LivingEntity)entity;
            viva.setRemoveWhenFarAway(false);
            viva.setCanPickupItems(false);
        }
        this.entity.setPersistent(false);
        this.entity.setVelocity(new Vector(0.0, 0.3, 0.0));
    }
}

