/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.items.contextos;

import es.pyronixstudio.base.juego.contextos.ContextExecutionType;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.items.AccionItem;
import es.pyronixstudio.base.juego.items.EstadoEjecuccion;
import es.pyronixstudio.base.juego.items.IIntercambiable;
import es.pyronixstudio.base.juego.items.ItemPersonalizadoLanzable;
import es.pyronixstudio.base.juego.items.contextos.ItemDamagePlayerContext;
import es.pyronixstudio.base.juego.items.contextos.ItemExecutionContext;
import es.pyronixstudio.base.juego.items.contextos.ItemExecutionErrors;
import es.pyronixstudio.base.juego.items.contextos.ItemHitContext;
import es.pyronixstudio.base.juego.items.contextos.ItemLaunchContext;
import es.pyronixstudio.base.juego.items.contextos.ItemUseContext;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistradorNameSpaceBase;
import es.pyronixstudio.base.util.ItemStackUtil;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class ItemContextHandler<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>> {
    private final Map<ContextExecutionType, Consumer<? extends ItemExecutionContext<J, E, P>>> handlers = new HashMap<ContextExecutionType, Consumer<? extends ItemExecutionContext<J, E, P>>>();

    public ItemContextHandler() {
        this.registrarHandler(ContextExecutionType.USE, this::itemUse);
        this.registrarHandler(ContextExecutionType.HIT, this::itemHit);
        this.registrarHandler(ContextExecutionType.LAUNCH, this::itemLaunch);
        this.registrarHandler(ContextExecutionType.DAMAGE, this::itemDamagePlayer);
    }

    private <C extends ItemExecutionContext<J, E, P>> void registrarHandler(ContextExecutionType contextType, Consumer<C> consumidor) {
        this.handlers.putIfAbsent(contextType, consumidor);
    }

    public void distpatchContext(ItemExecutionContext<J, E, P> context) {
        AccionItem<J, E, P> accion = context.getAccion();
        accion.onPreCooldownTest(context);
        EstadoEjecuccion estadoEjecuccion = context.estadoEjecuccion;
        accion.testCooldown(context);
        if (estadoEjecuccion.isNoProcesar()) {
            return;
        }
        Consumer<ItemExecutionContext<J, E, P>> handler = this.handlers.get((Object)context.executionType);
        handler.accept((ItemExecutionContext)CastUtil.cast(context));
        if (estadoEjecuccion.isEmpty()) {
            throw new ItemExecutionErrors.NoExecutionState();
        }
        if (estadoEjecuccion.isOk() && !estadoEjecuccion.isNoConsumir()) {
            ItemStack stackInv;
            int cantidad = (stackInv = (ItemStack)context.itemStackInvJugador.get()).getAmount() - 1;
            stackInv.setAmount(cantidad <= 0 ? 0 : cantidad);
            context.itemManager.ifPresent(arg_0 -> context.jugadorEjecutor.actualizarInv(arg_0));
        }
    }

    private void itemLaunch(ItemLaunchContext<J, E, P> context) {
        EstadoEjecuccion estadoEjecuccion = context.estadoEjecuccion;
        ItemStack invJugadorStack = (ItemStack)context.itemStackInvJugador.get();
        Boolean itemTransformado = (Boolean)ItemStackUtil.getDataFromItemStack(invJugadorStack, RegistradorNameSpaceBase.ITEMSTACK_TRANSFORMADO, PersistentDataType.BOOLEAN);
        context.itemPersonalizado.ifPresent(item -> {
            AbstractJugador jugador = context.jugadorEjecutor;
            Player player = jugador.getMinecraftPlayer();
            Snowball snow = (Snowball)player.launchProjectile(Snowball.class);
            context.projectile.set((Object)snow);
            AccionItem accion = context.getAccion();
            ItemPersonalizadoLanzable lanzable = (ItemPersonalizadoLanzable)CastUtil.cast((Object)item);
            accion.setProjectileProperties(context);
            ItemMeta meta = invJugadorStack.getItemMeta();
            if (meta == null) {
                return;
            }
            int customModelDataItem = meta.getCustomModelData();
            ItemStack proyectilStack = lanzable.getItemStackProyectil(invJugadorStack.getType(), customModelDataItem);
            Wrapper tipo = Wrapper.empty();
            if (itemTransformado != null) {
                IIntercambiable intercambiable = (IIntercambiable)CastUtil.cast(accion);
                intercambiable.transformarProyectil((Wrapper<Material>)tipo, context);
            }
            if (tipo.isPresent()) {
                proyectilStack = proyectilStack.withType((Material)tipo.get());
            }
            ItemStackUtil.setDataToItemStack(proyectilStack, RegistradorNameSpaceBase.ITEM_USE_TYPE, PersistentDataType.STRING, context.useType.name());
            snow.setItem(proyectilStack);
            if (context.isOnLaunch()) {
                accion.onLaunch(context);
                jugador.setIgnoreLeftInteraction(true);
                if (context.isSwingAnimation()) {
                    player.swingMainHand();
                }
            }
        }).ifEmpty(estadoEjecuccion::setError);
    }

    private void itemUse(ItemUseContext<J, E, P> context) {
        context.getAccion().onUse(context);
    }

    private void itemHit(ItemHitContext<J, E, P> context) {
        context.getAccion().onHit(context);
    }

    private void itemDamagePlayer(ItemDamagePlayerContext<J, E, P> context) {
        context.getAccion().onDamagePlayer(context);
    }
}

