/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.items.contextos;

import es.pyronixstudio.base.juego.contextos.ContextExecutionType;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.items.ItemManager;
import es.pyronixstudio.base.juego.items.ItemPersonalizadoLanzable;
import es.pyronixstudio.base.juego.items.contextos.ItemExecutionContext;
import es.pyronixstudio.base.juego.items.contextos.ItemExecutionErrors;
import es.pyronixstudio.base.juego.items.contextos.ItemUseContext;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.util.Ubicacion;
import es.pyronixstudio.util.wrapper.Wrapper;
import org.bukkit.Location;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.ItemStack;

public class ItemLaunchContext<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
extends ItemExecutionContext<J, E, P> {
    public final Wrapper<Projectile> projectile = Wrapper.emptyUnmodifiable();
    public final Ubicacion.WorldLocation relativePlayerLaunch;
    public final Location spawnIn;
    private boolean needOnLaunch = true;
    private boolean swingAnimation = true;
    public final ItemUseContext.EnumUseType useType;

    public ItemLaunchContext(ItemManager<J, E, P> itemManager, J jugador, String idItemPersonalizado, ItemUseContext.EnumUseType useType, Ubicacion.WorldLocation relativePlayerLaunch, Location spawnIn) {
        super(itemManager, jugador, idItemPersonalizado, ContextExecutionType.LAUNCH);
        this.relativePlayerLaunch = relativePlayerLaunch;
        this.useType = useType;
        this.spawnIn = spawnIn;
    }

    public ItemLaunchContext(ItemManager<J, E, P> itemManager, J jugador, String idItemPersonalizado, ItemUseContext.EnumUseType useType) {
        this(itemManager, jugador, idItemPersonalizado, useType, null, null);
    }

    public ItemLaunchContext(ItemLaunchContext<J, E, P> context, Ubicacion.WorldLocation relativePlayerLaunch) {
        this((ItemManager)context.itemManager.get(), context.jugadorEjecutor, context.idItemPersonalizado, context.useType, relativePlayerLaunch, null);
        this.itemStackInvJugador.set((Object)((ItemStack)context.itemStackInvJugador.get()));
    }

    public boolean isOnLaunch() {
        return this.needOnLaunch;
    }

    public void disableOnLaunch() {
        this.needOnLaunch = false;
    }

    public void disableSwingAnimation() {
        this.swingAnimation = false;
    }

    public boolean isSwingAnimation() {
        return this.swingAnimation;
    }

    @Override
    protected void preDispatch() {
        this.itemPersonalizado.ifPresent(item -> {
            boolean lanzable = item instanceof ItemPersonalizadoLanzable;
            if (!lanzable) {
                throw new ItemExecutionErrors.NoItemPersonalizadoLanzableException();
            }
        });
    }
}

