/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.entidades.display;

import es.pyronixstudio.base.core.PyronixScheduler;
import es.pyronixstudio.base.juego.entidades.display.DisplayEntity;
import es.pyronixstudio.base.juego.entidades.display.TransformacionDisplay;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.registros.tipo.IRegistro;
import es.pyronixstudio.base.util.Ubicacion;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;

public class DisplayEntityManager
implements IReseteable,
PyronixScheduler.PyronixTaskRunnable {
    private final Map<Ubicacion.BlockLocation, DisplayEntity<Display>> entidadesPorUbicacion = new ConcurrentHashMap<Ubicacion.BlockLocation, DisplayEntity<Display>>();
    private final PyronixScheduler.PyronixTask task = PyronixScheduler.runTaskTimer(100L, 1L, this);

    @Override
    public boolean reset(AbstractPartida<?, ?, ?> partida) {
        this.task.cancel();
        this.entidadesPorUbicacion.keySet().forEach(this::remove);
        return false;
    }

    private IRegistro<TransformacionDisplay<Display>> getTransformacion(Display display) {
        if (display instanceof BlockDisplay) {
            BlockDisplay block = (BlockDisplay)display;
            Material material = block.getBlock().getMaterial();
            return RegistrosBase.DISPLAY_TRANSFORMACIONES.get((Enum<?>)material);
        }
        return null;
    }

    public void add(Location ubicacion, Display entity) {
        this.entidadesPorUbicacion.put(Ubicacion.BlockLocation.fromBukkit(ubicacion), DisplayEntity.of(this.getTransformacion(entity), entity));
    }

    public void remove(Ubicacion.BlockLocation ubicacion) {
        DisplayEntity<Display> displayEntity = this.entidadesPorUbicacion.remove(ubicacion);
        if (displayEntity != null) {
            displayEntity.entidad.remove();
        }
    }

    public void remove(Location ubicacion) {
        this.remove(Ubicacion.BlockLocation.fromBukkit(ubicacion));
    }

    @Override
    public void run(PyronixScheduler.PyronixTask task) {
        this.entidadesPorUbicacion.values().forEach(displayEntity -> displayEntity.transformacion.ifPresent(TransformacionDisplay::transformar));
    }
}

