/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.comandos;

import es.pyronixstudio.base.comandos.AbstractComandoAvanzado;
import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public abstract class AbstractComandoBasePartida<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
extends AbstractComandoAvanzado {
    private final boolean idEnUsoAutocompletar;
    protected final PyronixPlugin<J, E, P> plugin;

    public AbstractComandoBasePartida(boolean idEnUsoAutocompletar, PyronixPlugin<J, E, P> plugin) {
        this.idEnUsoAutocompletar = idEnUsoAutocompletar;
        this.plugin = plugin;
    }

    protected abstract List<String> autoCompletarExtra(CommandSender var1, Command var2, String var3, Wrapper<Integer> var4, List<String> var5);

    protected abstract void onCommandExtra(CommandSender var1, String var2, Wrapper<Integer> var3, List<String> var4);

    public final boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (this.isCommandBlock(sender)) {
            return true;
        }
        if (!this.isOP(sender)) {
            return true;
        }
        boolean multiPartida = this.plugin.partidaManager.isMultiPartida();
        if (multiPartida && (args.length == 0 || !this.esNumero(args[0]))) {
            this.enviarMensaje(String.format("<red>Uso del comando: /%s <ID>", label), sender);
            return true;
        }
        Wrapper id = Wrapper.empty();
        if (multiPartida) {
            id = Wrapper.of((Object)Integer.parseInt(args[0]));
        }
        this.onCommandExtra(sender, label, (Wrapper<Integer>)id, this.quitarPrimerArgumento(args));
        return true;
    }

    @Override
    public final List<String> autoCompletarComando(CommandSender sender, Command command, String label, String[] args) {
        List<String> extra;
        if (!this.isOP(sender, false)) {
            return null;
        }
        ArrayList<String> autoCompletar = new ArrayList<String>();
        int size = args.length;
        boolean multiPartida = this.plugin.partidaManager.isMultiPartida();
        if (multiPartida && size == 1) {
            if (this.idEnUsoAutocompletar) {
                autoCompletar.addAll(this.listaIntegerString(this.plugin.partidaManager.getIdsEnUso()));
            } else {
                autoCompletar.addAll(this.listaIntegerString(this.plugin.partidaManager.getIdsLibres()));
            }
        }
        Wrapper id = Wrapper.empty();
        if (multiPartida && size > 1 && this.esNumero(args[0])) {
            id = Wrapper.of((Object)Integer.parseInt(args[0]));
        }
        if ((extra = this.autoCompletarExtra(sender, command, label, (Wrapper<Integer>)id, this.quitarPrimerArgumento(args))) != null) {
            autoCompletar.addAll(extra);
        }
        return autoCompletar;
    }

    private final List<String> listaIntegerString(Collection<Integer> lista) {
        return lista.stream().map(id -> Integer.toString(id)).toList();
    }

    private List<String> quitarPrimerArgumento(String ... args) {
        ArrayList<String> argumentos = new ArrayList<String>(List.of(args));
        if (argumentos.size() > 0 && this.plugin.partidaManager.isMultiPartida()) {
            argumentos.remove(0);
        }
        return argumentos;
    }
}

