/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa.generadores;

import es.pyronixstudio.base.juego.items.ItemManager;
import es.pyronixstudio.base.juego.items.ItemPersonalizado;
import es.pyronixstudio.base.juego.mapa.AbstractMapa;
import es.pyronixstudio.base.juego.mapa.MarcadorConfiguracion;
import es.pyronixstudio.base.juego.mapa.generadores.Generador;
import es.pyronixstudio.base.juego.mapa.generadores.generado.GeneradoItem;
import es.pyronixstudio.base.juego.mapa.generadores.generado.IGenerado;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.util.RandomUtil;
import es.pyronixstudio.util.colecciones.IndexedMap;
import es.pyronixstudio.util.ficheros.Valor;
import es.pyronixstudio.util.wrapper.Wrapper;

public class GeneradorItem
extends Generador {
    private final IndexedMap<ItemPersonalizado, Integer> itemsAGenerar;

    public GeneradorItem(MarcadorConfiguracion marcadorConfig, AbstractPartida<?, ?, ?> partida) {
        super(marcadorConfig, partida);
        ItemManager itemManager;
        IndexedMap crearMapa = null;
        AbstractMapa partidaMapa = (AbstractMapa)partida.componentSystem.get(RegistrosBase.COMPONENTES.MAPA);
        if (partidaMapa != null && (itemManager = partidaMapa.getItemManager()) != null) {
            crearMapa = IndexedMap.of(this.getElementosAGenerar(), key -> {
                Wrapper<ItemPersonalizado> optItem = itemManager.getItem((String)key);
                if (optItem.isPresent()) {
                    return (ItemPersonalizado)optItem.get();
                }
                return null;
            }, Valor::asInt);
        }
        this.itemsAGenerar = crearMapa;
    }

    @Override
    protected void procesarPreTick() {
    }

    @Override
    protected void procesarTick() {
    }

    @Override
    protected IGenerado generar(Generador.UbicacionTickeable location) {
        IndexedMap.IndexedEntry parejaGenerar;
        IndexedMap.IndexedEntry indexedEntry = parejaGenerar = this.random ? RandomUtil.getRandomFromIndexedMap(this.itemsAGenerar) : this.itemsAGenerar.getFirst();
        if (parejaGenerar == null) {
            return null;
        }
        int porGenerar = (Integer)parejaGenerar.getValue();
        if (porGenerar == 0) {
            return null;
        }
        if (porGenerar != -1) {
            int nuevoMaximo;
            if ((nuevoMaximo = --porGenerar) == 0) {
                parejaGenerar.remove();
            } else {
                parejaGenerar.setValue((Object)nuevoMaximo);
            }
        }
        return GeneradoItem.of(location, (ItemPersonalizado)parejaGenerar.getKey());
    }
}

