/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa.generadores;

import es.pyronixstudio.base.juego.entidades.display.DisplayEntityManager;
import es.pyronixstudio.base.juego.mapa.MarcadorConfiguracion;
import es.pyronixstudio.base.juego.mapa.generadores.Generador;
import es.pyronixstudio.base.juego.mapa.generadores.generado.GeneradoBloque;
import es.pyronixstudio.base.juego.mapa.generadores.generado.IGenerado;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.util.EnumUtil;
import es.pyronixstudio.util.RandomUtil;
import es.pyronixstudio.util.colecciones.IndexedMap;
import es.pyronixstudio.util.ficheros.Valor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;

public class GeneradorBloque
extends Generador {
    private final IndexedMap<Material, Integer> materialesAGenerar = IndexedMap.of(this.getElementosAGenerar(), clave -> (Material)EnumUtil.valueOfSecure(Material.class, (String)clave), Valor::asInt);
    private final int alturaRelativaDisplayEntity;
    private final Material displayBlockMaterial;
    private final DisplayEntityManager displayEntitiesManager;
    private final Material bloqueReset;

    public GeneradorBloque(MarcadorConfiguracion marcadorConfig, AbstractPartida<?, ?, ?> partida) {
        super(marcadorConfig, partida);
        this.alturaRelativaDisplayEntity = marcadorConfig.config.getOrDefault("displayEntityAlturaRelativa", (Object)0).asInt();
        Valor valorDisplayBlock = marcadorConfig.config.get("displayEntityBlock");
        Material displayBlockMaterial = null;
        if (valorDisplayBlock != null) {
            displayBlockMaterial = (Material)valorDisplayBlock.asEnum(Material.class);
        }
        this.displayBlockMaterial = displayBlockMaterial;
        this.displayEntitiesManager = (DisplayEntityManager)partida.componentSystem.get(RegistrosBase.COMPONENTES.DISPLAY_ENTITY_MANAGER);
        this.bloqueReset = (Material)marcadorConfig.config.getOrDefault("bloqueReset", (Object)Material.AIR).asEnum(Material.class);
    }

    @Override
    protected void procesarPreTick() {
    }

    @Override
    protected void procesarTick() {
    }

    @Override
    protected IGenerado generar(Generador.UbicacionTickeable location) {
        IndexedMap.IndexedEntry parejaGenerar;
        IndexedMap.IndexedEntry indexedEntry = parejaGenerar = this.random ? RandomUtil.getRandomFromIndexedMap(this.materialesAGenerar) : this.materialesAGenerar.getFirst();
        if (parejaGenerar == null) {
            return null;
        }
        int porGenerar = (Integer)parejaGenerar.getValue();
        if (porGenerar == 0) {
            return null;
        }
        if (porGenerar != -1) {
            int nuevoMaximo;
            if ((nuevoMaximo = --porGenerar) == 0) {
                parejaGenerar.remove();
            } else {
                parejaGenerar.setValue((Object)nuevoMaximo);
            }
        }
        if (this.displayBlockMaterial != null && this.displayEntitiesManager != null) {
            Location minecraftLocation = location.getMinecraftLocation();
            minecraftLocation.getWorld().spawn(minecraftLocation.clone().add(0.0, (double)this.alturaRelativaDisplayEntity, 0.0), BlockDisplay.class, entidad -> {
                entidad.setBlock(this.displayBlockMaterial.createBlockData());
                this.displayEntitiesManager.add(minecraftLocation, (Display)entidad);
            });
        }
        return GeneradoBloque.of(location, (Material)parejaGenerar.getKey(), this.bloqueReset);
    }
}

