/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa.generadores.generado;

import es.pyronixstudio.base.juego.mapa.generadores.generado.IGenerado;
import es.pyronixstudio.base.util.Ubicacion;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class GeneradoBloque
implements IGenerado {
    public final Location location;
    public final Material material;
    public final Block block;
    public final Material bloqueReset;

    public static GeneradoBloque of(Ubicacion.BlockLocation location, Material material, Material bloqueReset) {
        GeneradoBloque generadoBloque = new GeneradoBloque(location, material, bloqueReset);
        generadoBloque.init();
        return generadoBloque;
    }

    private GeneradoBloque(Ubicacion.BlockLocation location, Material material, Material bloqueReset) {
        this.location = location.getMinecraftLocation();
        this.block = this.location.getBlock();
        this.material = material;
        this.bloqueReset = bloqueReset;
    }

    @Override
    public void init() {
        this.setMaterial(this.material);
    }

    private void setMaterial(Material material) {
        this.block.setType(material);
    }

    @Override
    public boolean sigueExistiendo() {
        return this.getType() == this.material;
    }

    private Material getType() {
        return this.block.getType();
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void reset() {
        this.setMaterial(this.bloqueReset);
    }

    public String toString() {
        return this.material.name();
    }
}

